/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.StreamChunkId;

public final class ChunkFetchFailure
extends AbstractMessage
implements ResponseMessage {
    public final StreamChunkId streamChunkId;
    public final String errorString;

    public ChunkFetchFailure(StreamChunkId streamChunkId, String errorString) {
        this.streamChunkId = streamChunkId;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.ChunkFetchFailure;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkId.encodedLength() + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkId.encode(buf);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static ChunkFetchFailure decode(ByteBuf buf) {
        StreamChunkId streamChunkId = StreamChunkId.decode(buf);
        String errorString = Encoders.Strings.decode(buf);
        return new ChunkFetchFailure(streamChunkId, errorString);
    }

    public int hashCode() {
        return Objects.hash(this.streamChunkId, this.errorString);
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchFailure) {
            ChunkFetchFailure o = (ChunkFetchFailure)other;
            return this.streamChunkId.equals(o.streamChunkId) && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return "ChunkFetchFailure[streamChunkId=" + String.valueOf(this.streamChunkId) + ",errorString=" + this.errorString + "]";
    }
}

