/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow;

import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.TrustedDevicesMultifactorProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.trusted.authentication.MultifactorAuthenticationTrustedDeviceBypassEvaluator;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustRecord;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.trusted.web.flow.MultifactorAuthenticationTrustBean;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationSetTrustAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationSetTrustAction.class);
    private final MultifactorAuthenticationTrustStorage storageService;
    private final DeviceFingerprintStrategy deviceFingerprintStrategy;
    private final TrustedDevicesMultifactorProperties trustedProperties;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator;

    public Event doExecute(RequestContext requestContext) {
        WebApplicationService service;
        Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        if (authn == null) {
            LOGGER.error("Could not determine authentication from the request context");
            return this.error();
        }
        RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
        if (this.bypassEvaluator.shouldBypassTrustedDevice(registeredService, (Service)(service = WebUtils.getService((RequestContext)requestContext)), authn)) {
            LOGGER.debug("Trusted device registration is disabled for [{}]", (Object)registeredService);
            return this.success();
        }
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authn);
        Optional deviceBean = WebUtils.getMultifactorAuthenticationTrustRecord((RequestContext)requestContext, MultifactorAuthenticationTrustBean.class);
        if (deviceBean.isEmpty()) {
            LOGGER.debug("No device information is provided. Trusted authentication record is not stored and tracked");
            return this.success();
        }
        MultifactorAuthenticationTrustBean deviceRecord = (MultifactorAuthenticationTrustBean)deviceBean.get();
        if (StringUtils.isBlank((CharSequence)deviceRecord.getDeviceName())) {
            LOGGER.debug("No device name is provided. Trusted authentication record is not stored and tracked");
            return this.success();
        }
        if (!MultifactorAuthenticationTrustUtils.isMultifactorAuthenticationTrustedInScope(requestContext)) {
            this.storeTrustedAuthenticationRecord(requestContext, authn, deviceRecord);
        }
        LOGGER.debug("Trusted authentication session exists for [{}]", (Object)authn.getPrincipal().getId());
        MultifactorAuthenticationTrustUtils.trackTrustedMultifactorAuthenticationAttribute(authn, this.trustedProperties.getCore().getAuthenticationContextAttribute());
        WebUtils.putAuthentication((Authentication)authn, (RequestContext)requestContext);
        return this.success();
    }

    protected void storeTrustedAuthenticationRecord(RequestContext requestContext, Authentication authentication, MultifactorAuthenticationTrustBean deviceRecord) {
        String principal = authentication.getPrincipal().getId();
        LOGGER.debug("Attempting to store trusted authentication record for [{}] as device [{}]", (Object)principal, (Object)deviceRecord.getDeviceName());
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String fingerprint = this.deviceFingerprintStrategy.determineFingerprintComponent(principal, request, response);
        MultifactorAuthenticationTrustRecord record = MultifactorAuthenticationTrustRecord.newInstance(principal, MultifactorAuthenticationTrustUtils.generateGeography(), fingerprint);
        record.setName(deviceRecord.getDeviceName());
        if (deviceRecord.getTimeUnit() != ChronoUnit.FOREVER && deviceRecord.getExpiration() > 0L) {
            record.expireIn(deviceRecord.getExpiration(), deviceRecord.getTimeUnit());
        } else {
            record.neverExpire();
        }
        LOGGER.debug("Trusted authentication record will expire at [{}]", (Object)record.getExpirationDate());
        this.storageService.save(record);
        LOGGER.debug("Saved trusted authentication record for [{}] under [{}]", (Object)principal, (Object)record.getName());
    }

    @Generated
    public MultifactorAuthenticationSetTrustAction(MultifactorAuthenticationTrustStorage storageService, DeviceFingerprintStrategy deviceFingerprintStrategy, TrustedDevicesMultifactorProperties trustedProperties, AuditableExecution registeredServiceAccessStrategyEnforcer, MultifactorAuthenticationTrustedDeviceBypassEvaluator bypassEvaluator) {
        this.storageService = storageService;
        this.deviceFingerprintStrategy = deviceFingerprintStrategy;
        this.trustedProperties = trustedProperties;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.bypassEvaluator = bypassEvaluator;
    }

    @Generated
    public MultifactorAuthenticationTrustStorage getStorageService() {
        return this.storageService;
    }

    @Generated
    public DeviceFingerprintStrategy getDeviceFingerprintStrategy() {
        return this.deviceFingerprintStrategy;
    }

    @Generated
    public TrustedDevicesMultifactorProperties getTrustedProperties() {
        return this.trustedProperties;
    }

    @Generated
    public AuditableExecution getRegisteredServiceAccessStrategyEnforcer() {
        return this.registeredServiceAccessStrategyEnforcer;
    }

    @Generated
    public MultifactorAuthenticationTrustedDeviceBypassEvaluator getBypassEvaluator() {
        return this.bypassEvaluator;
    }
}

