/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.authorization;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.authorization.BaseOAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator
extends BaseOAuth20AuthorizationRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator.class);
    private int order = Integer.MAX_VALUE;

    public OAuth20AuthorizationCodeResponseTypeAuthorizationRequestValidator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, OAuth20RequestParameterResolver requestParameterResolver) {
        super(servicesManager, webApplicationServiceServiceFactory, registeredServiceAccessStrategyEnforcer, requestParameterResolver);
    }

    public boolean validate(WebContext context) {
        Optional clientIdResult = this.requestParameterResolver.resolveRequestParameter(context, "client_id");
        return clientIdResult.map(clientId -> {
            if (!this.requestParameterResolver.isAuthorizedResponseTypeForService(context, this.getRegisteredServiceByClientId((String)clientId))) {
                Optional responseTypeResult = this.requestParameterResolver.resolveRequestParameter(context, "response_type");
                String msg = String.format("Client is not allowed to use the [%s] response type", responseTypeResult.orElse("unknown"));
                LOGGER.warn(msg);
                this.setErrorDetails(context, "unauthorized_client", msg, true);
                return false;
            }
            return true;
        }).orElse(false);
    }

    public boolean supports(WebContext context) throws Exception {
        if (this.preValidate(context)) {
            Optional responseType = this.requestParameterResolver.resolveRequestParameter(context, "response_type");
            return OAuth20Utils.isResponseType(responseType.map(String::valueOf).orElse(""), this.getResponseType());
        }
        return false;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.CODE;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

