/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthCodeExpirationPolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeExpirationPolicy;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.ticket.code.OAuth20DefaultCode;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultOAuthCodeFactory
implements OAuth20CodeFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultOAuthCodeFactory.class);
    protected final UniqueTicketIdGenerator oAuthCodeIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20Code> expirationPolicy;
    protected final ServicesManager servicesManager;
    protected final CipherExecutor<String, String> cipherExecutor;

    public OAuth20Code create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, Collection<String> scopes, String codeChallenge, String codeChallengeMethod, String clientId, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) {
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService(clientId);
        String codeId = this.oAuthCodeIdGenerator.getNewTicketId("OC");
        String codeIdToUse = (String)FunctionUtils.doIf((boolean)this.cipherExecutor.isEnabled(), () -> {
            LOGGER.trace("Attempting to encode OAuth code [{}]", (Object)codeId);
            String encoded = (String)this.cipherExecutor.encode((Object)codeId);
            LOGGER.debug("Encoded OAuth code [{}]", (Object)encoded);
            return encoded;
        }, () -> codeId).get();
        OAuth20DefaultCode oauthCode = new OAuth20DefaultCode(codeIdToUse, service, authentication, expirationPolicyToUse, ticketGrantingTicket, scopes, codeChallenge, codeChallengeMethod, clientId, requestClaims, responseType, grantType);
        if (ticketGrantingTicket != null) {
            ticketGrantingTicket.getDescendantTickets().add(oauthCode.getId());
        }
        return oauthCode;
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20Code.class;
    }

    private ExpirationPolicy determineExpirationPolicyForService(String clientId) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        if (registeredService != null && registeredService.getCodeExpirationPolicy() != null) {
            RegisteredServiceOAuthCodeExpirationPolicy policy = registeredService.getCodeExpirationPolicy();
            long count = policy.getNumberOfUses();
            String ttl = policy.getTimeToLive();
            if (count > 0L && StringUtils.isNotBlank((CharSequence)ttl)) {
                return new OAuth20CodeExpirationPolicy(count, Beans.newDuration((String)ttl).getSeconds());
            }
        }
        return this.expirationPolicy.buildTicketExpirationPolicy();
    }

    @Generated
    public OAuth20DefaultOAuthCodeFactory(UniqueTicketIdGenerator oAuthCodeIdGenerator, ExpirationPolicyBuilder<OAuth20Code> expirationPolicy, ServicesManager servicesManager, CipherExecutor<String, String> cipherExecutor) {
        this.oAuthCodeIdGenerator = oAuthCodeIdGenerator;
        this.expirationPolicy = expirationPolicy;
        this.servicesManager = servicesManager;
        this.cipherExecutor = cipherExecutor;
    }
}

