/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public abstract class AbstractDAO<E extends Entity>
implements DAO<E> {
    protected static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    private static final Map<String, Boolean> IS_ORACLE = new ConcurrentHashMap<String, Boolean>();

    protected EntityManagerFactory entityManagerFactory() {
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)AuthContextUtils.getDomain());
    }

    protected EntityManager entityManager() {
        return Optional.ofNullable(EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory())).orElseThrow(() -> new IllegalStateException("Could not find EntityManager for domain " + AuthContextUtils.getDomain()));
    }

    public void refresh(E entity) {
        this.entityManager().refresh(entity);
    }

    public void detach(E entity) {
        this.entityManager().detach(entity);
    }

    protected boolean isOracle() {
        Boolean isOracle = IS_ORACLE.get(AuthContextUtils.getDomain());
        if (isOracle == null) {
            OpenJPAEntityManagerFactory emf = OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory());
            OpenJPAEntityManagerFactorySPI emfspi = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)emf);
            isOracle = ((MappingRepository)emfspi.getConfiguration().getMetaDataRepositoryInstance()).getDBDictionary() instanceof OracleDictionary;
            IS_ORACLE.put(AuthContextUtils.getDomain(), isOracle);
        }
        return isOracle;
    }
}

