/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.validation;

import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasSimpleMultifactorAuthenticationService
implements CasSimpleMultifactorAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasSimpleMultifactorAuthenticationService.class);
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;

    @Override
    public CasSimpleMultifactorAuthenticationTicket generate(Principal principal, Service service) throws Exception {
        CasSimpleMultifactorAuthenticationTicketFactory mfaFactory = (CasSimpleMultifactorAuthenticationTicketFactory)this.ticketFactory.get(CasSimpleMultifactorAuthenticationTicket.class);
        CasSimpleMultifactorAuthenticationTicket token = mfaFactory.create(service, CollectionUtils.wrap((String)"principal", (Object)principal));
        LOGGER.debug("Created multifactor authentication token [{}] for service [{}]", (Object)token.getId(), (Object)service);
        return token;
    }

    @Override
    public void store(CasSimpleMultifactorAuthenticationTicket token) {
        token.update();
        Ticket trackingToken = this.ticketRegistry.getTicket(token.getId());
        FunctionUtils.doUnchecked(us -> {
            if (trackingToken != null) {
                LOGGER.debug("Updating existing token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.updateTicket(trackingToken);
            } else {
                LOGGER.debug("Adding token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.addTicket((Ticket)token);
            }
        }, (Object[])new Object[0]);
    }

    @Override
    public Principal validate(Authentication authentication, CasSimpleMultifactorTokenCredential credential) throws Exception {
        String uid = authentication.getPrincipal().getId();
        String tokenId = DefaultCasSimpleMultifactorAuthenticationService.normalize(credential.getId());
        LOGGER.debug("Received token [{}] and pricipal id [{}]", (Object)tokenId, (Object)uid);
        CasSimpleMultifactorAuthenticationTicket acct = (CasSimpleMultifactorAuthenticationTicket)this.ticketRegistry.getTicket(tokenId, CasSimpleMultifactorAuthenticationTicket.class);
        Map<String, Object> properties = acct.getProperties();
        if (!properties.containsKey("principal")) {
            LOGGER.warn("Unable to locate principal for token [{}]", (Object)tokenId);
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + tokenId);
        }
        Principal principal = (Principal)properties.get("principal");
        if (!principal.equals(authentication.getPrincipal())) {
            LOGGER.warn("Principal assigned to token [{}] is unauthorized for token [{}]", (Object)principal.getId(), (Object)tokenId);
            this.deleteToken(acct);
            throw new FailedLoginException("Failed to authenticate code " + tokenId);
        }
        this.deleteToken(acct);
        LOGGER.debug("Validated token [{}] successfully for [{}].", (Object)tokenId, (Object)uid);
        return principal;
    }

    private static String normalize(String tokenId) {
        if (!tokenId.startsWith("CASMFA")) {
            return "CASMFA-" + tokenId;
        }
        return tokenId;
    }

    protected void deleteToken(CasSimpleMultifactorAuthenticationTicket acct) {
        FunctionUtils.doUnchecked(s -> this.ticketRegistry.deleteTicket(acct.getId()), (Object[])new Object[0]);
    }

    @Generated
    public DefaultCasSimpleMultifactorAuthenticationService(TicketRegistry ticketRegistry, TicketFactory ticketFactory) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }
}

