/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config.jcs;

import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.DomUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.config.AbstractCacheModelParser;
import org.springmodules.cache.provider.jcs.JcsCachingModel;
import org.springmodules.cache.provider.jcs.JcsFlushingModel;
import org.w3c.dom.Element;

public final class JcsModelParser
extends AbstractCacheModelParser {
    public CachingModel parseCachingModel(Element element) {
        String cacheName = element.getAttribute("cacheName");
        String group = element.getAttribute("group");
        JcsCachingModel model = new JcsCachingModel(cacheName, group);
        return model;
    }

    protected FlushingModel doParseFlushingModel(Element element, boolean flushBeforeMethodExecution) {
        JcsFlushingModel model = new JcsFlushingModel();
        List cacheElements = DomUtils.getChildElementsByTagName((Element)element, (String)"cache");
        if (!CollectionUtils.isEmpty((Collection)cacheElements)) {
            int count = cacheElements.size();
            JcsFlushingModel.CacheStruct[] cacheStructs = new JcsFlushingModel.CacheStruct[count];
            for (int i = 0; i < count; ++i) {
                JcsFlushingModel.CacheStruct cache;
                Element cacheElement = (Element)cacheElements.get(i);
                String cacheName = cacheElement.getAttribute("name");
                String groups = cacheElement.getAttribute("groups");
                cacheStructs[i] = cache = new JcsFlushingModel.CacheStruct(cacheName, groups);
            }
            model.setCacheStructs(cacheStructs);
        }
        model.setFlushBeforeMethodExecution(flushBeforeMethodExecution);
        return model;
    }
}

