/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;

public class AllowedSchemas<S extends Schema> {
    private final Set<S> forSelf = new HashSet<S>();
    private final Map<Group, Set<S>> forMemberships = new HashMap<Group, Set<S>>();

    public Set<S> getForSelf() {
        return this.forSelf;
    }

    public Set<S> getForMembership(Group group) {
        return this.forMemberships.get(group) == null ? Set.of() : this.forMemberships.get(group);
    }

    public Map<Group, Set<S>> getForMemberships() {
        return this.forMemberships;
    }

    public boolean forSelfContains(S schema) {
        return this.forSelf.contains(schema);
    }

    public boolean forSelfContains(String schema) {
        return this.forSelf.stream().anyMatch(new KeyMatches(schema));
    }

    public boolean forMembershipsContains(Group group, S schema) {
        return this.getForMembership(group).stream().anyMatch(s -> s.equals(schema));
    }

    public boolean forMembershipsContains(S schema) {
        return this.forMemberships.entrySet().stream().anyMatch(entry -> ((Set)entry.getValue()).contains(schema));
    }

    public boolean forMembershipsContains(Group group, String schema) {
        return this.getForMembership(group).stream().anyMatch(new KeyMatches(schema));
    }

    public boolean forMembershipsContains(String schema) {
        KeyMatches keyMatches = new KeyMatches(schema);
        return this.forMemberships.entrySet().stream().anyMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(keyMatches));
    }

    public boolean contains(S schema) {
        if (this.forSelfContains(schema)) {
            return true;
        }
        return this.forMembershipsContains(schema);
    }

    public boolean contains(String schema) {
        if (this.forSelfContains(schema)) {
            return true;
        }
        return this.forMembershipsContains(schema);
    }

    private class KeyMatches
    implements Predicate<S> {
        private final String schema;

        KeyMatches(String schema) {
            this.schema = schema;
        }

        @Override
        public boolean test(S object) {
            return object.getKey().equals(this.schema);
        }
    }
}

