/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.status;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.apache.syncope.client.ui.commons.panels.LabelPanel;
import org.apache.syncope.client.ui.commons.status.Status;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public final class StatusUtils
implements Serializable {
    private static final long serialVersionUID = 7238009174387184309L;

    public static StatusBean getStatusBean(AnyTO anyTO, String resource, ConnObject connObject, boolean notUser) {
        StatusBean statusBean = new StatusBean(anyTO, resource);
        if (connObject != null) {
            Boolean enabled = StatusUtils.isEnabled(connObject);
            statusBean.setStatus(Optional.ofNullable(enabled).map(aBoolean -> aBoolean != false ? Status.ACTIVE : Status.SUSPENDED).orElseGet(() -> notUser ? Status.ACTIVE : Status.UNDEFINED));
            statusBean.setConnObjectLink(StatusUtils.getConnObjectLink(connObject));
        }
        return statusBean;
    }

    public static StatusBean getStatusBean(RealmTO realmTO, String resource, ConnObject connObject) {
        StatusBean statusBean = new StatusBean(realmTO, resource);
        if (connObject != null) {
            Boolean enabled = StatusUtils.isEnabled(connObject);
            statusBean.setStatus(Optional.ofNullable(enabled).filter(aBoolean -> aBoolean == false).map(aBoolean -> Status.SUSPENDED).orElse(Status.ACTIVE));
            statusBean.setConnObjectLink(StatusUtils.getConnObjectLink(connObject));
        }
        return statusBean;
    }

    public static Boolean isEnabled(ConnObject connObject) {
        return connObject.getAttr("__ENABLE__").filter(s -> !s.getValues().isEmpty()).map(s -> Boolean.valueOf((String)s.getValues().get(0))).orElse(Boolean.FALSE);
    }

    public static String getConnObjectLink(ConnObject connObject) {
        return connObject.getAttr("__NAME__").filter(s -> !s.getValues().isEmpty()).map(s -> (String)s.getValues().get(0)).orElse(null);
    }

    public static StatusR statusR(String key, StatusRType type, Collection<StatusBean> statuses) {
        StatusR.Builder builder = new StatusR.Builder(key, type).onSyncope(false);
        statuses.forEach(status -> {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
            } else {
                builder.resource(status.getResource());
            }
        });
        return builder.build();
    }

    public static Panel getStatusImagePanel(String componentId, Status status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, Status status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_YET_SUBMITTED: {
                alt = "undefined icon";
                title = "Not yet submitted";
                clazz = "fas fa-question-circle";
                break;
            }
            case ACTIVE: {
                alt = "active icon";
                title = "Enabled";
                clazz = "far fa-check-circle";
                break;
            }
            case UNDEFINED: {
                alt = "undefined icon";
                title = "Undefined status";
                clazz = "fas fa-question-circle";
                break;
            }
            case OBJECT_NOT_FOUND: {
                alt = "notfound icon";
                title = "Not found";
                clazz = "fas fa-minus-circle";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "far fa-check-circle";
                break;
            }
            case SUSPENDED: {
                alt = "inactive icon";
                title = "Disabled";
                clazz = "fas fa-ban";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Panel getStatusImagePanel(String componentId, ExecStatus status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, ExecStatus status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_ATTEMPTED: {
                alt = "not attempted";
                title = "Not attempted";
                clazz = "fas fa-question-circle";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "far fa-check-circle";
                break;
            }
            case SUCCESS: {
                alt = "success icon";
                title = "Propagation succeded";
                clazz = "far fa-check-circle";
                break;
            }
            case FAILURE: {
                alt = "failure icon";
                title = "Propagation failed";
                clazz = "fas fa-minus-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Panel getWarningStatusPanel(String componentId) {
        return new LabelPanel(componentId, StatusUtils.getLabel("label", "warning icon", "Propagation failed", "fas fa-exclamation-circle"));
    }

    public static Label getLabel(String componentId, final String alt, final String title, final String clazz) {
        return new Label(componentId, (Serializable)((Object)"")){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("alt", (CharSequence)alt);
                tag.put("title", (CharSequence)title);
                tag.put("class", (CharSequence)clazz);
            }
        };
    }

    private StatusUtils() {
    }
}

