/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(TaskJob.class);
    @Autowired
    private DomainHolder domainHolder;
    private SchedTaskJobDelegate delegate;

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String taskKey = context.getMergedJobDataMap().getString("taskKey");
        try {
            String domain = context.getMergedJobDataMap().getString("domain");
            if (this.domainHolder.getDomains().containsKey(domain)) {
                AuthContextUtils.callAsAdmin((String)domain, () -> {
                    try {
                        ImplementationDAO implementationDAO = (ImplementationDAO)ApplicationContextProvider.getApplicationContext().getBean(ImplementationDAO.class);
                        Implementation impl = implementationDAO.find(context.getMergedJobDataMap().getString("delegateImpl"));
                        if (impl == null) {
                            LOG.error("Could not find Implementation '{}', aborting", (Object)context.getMergedJobDataMap().getString("delegateImpl"));
                        } else {
                            this.delegate = (SchedTaskJobDelegate)ImplementationManager.build((Implementation)impl);
                            this.delegate.execute((TaskType)context.getMergedJobDataMap().get((Object)"taskType"), taskKey, context.getMergedJobDataMap().getBoolean("dryRun"), context);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("While executing task {}", (Object)taskKey, (Object)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            } else {
                LOG.debug("Domain {} not found, skipping", (Object)domain);
            }
        }
        catch (RuntimeException e) {
            LOG.error("While executing task {}", (Object)taskKey, (Object)e);
            throw new JobExecutionException("While executing task " + taskKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

