/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.jwks;

import io.swagger.v3.oas.annotations.Operation;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;

@RestControllerEndpoint(id="oidcJwks", enableByDefault=false)
public class OidcJwksRotationEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<OidcJsonWebKeystoreRotationService> rotationService;

    public OidcJwksRotationEndpoint(CasConfigurationProperties casProperties, ObjectProvider<OidcJsonWebKeystoreRotationService> rotationService) {
        super(casProperties);
        this.rotationService = rotationService;
    }

    @GetMapping(path={"/rotate"}, produces={"application/json"})
    @Operation(summary="Rotate keys in the keystore forcefully")
    public ResponseEntity<String> handleRotation() throws Exception {
        JsonWebKeySet rotation = ((OidcJsonWebKeystoreRotationService)this.rotationService.getObject()).rotate();
        return new ResponseEntity((Object)rotation.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY), HttpStatus.OK);
    }

    @GetMapping(path={"/revoke"}, produces={"application/json"})
    @Operation(summary="Revoke keys in the keystore forcefully")
    public ResponseEntity<String> handleRevocation() throws Exception {
        JsonWebKeySet rotation = ((OidcJsonWebKeystoreRotationService)this.rotationService.getObject()).revoke();
        return new ResponseEntity((Object)rotation.toJson(JsonWebKey.OutputControlLevel.PUBLIC_ONLY), HttpStatus.OK);
    }
}

