/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.exceptions;

import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Uid;

public class RetryableException
extends ConnectorException {
    private static final long serialVersionUID = 1L;

    private RetryableException(Throwable cause) {
        super(cause);
    }

    private RetryableException(String message, Throwable cause) {
        super(message, cause);
    }

    public static RetryableException wrap(String message, Throwable cause) {
        if (cause instanceof RetryableException) {
            return (RetryableException)cause;
        }
        if (null != message) {
            return new RetryableException(message, cause);
        }
        return new RetryableException(cause);
    }

    public static RetryableException wrap(String message, Uid uid) {
        return new RetryableException(message, new AlreadyExistsException().initUid(Assertions.nullChecked(uid, "Uid")));
    }
}

