/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.SecuredModel;

public abstract class AbstractStateModel
extends AbstractModel {
    private String id;
    private String parent;
    private LinkedList<AttributeModel> attributes;
    private SecuredModel secured;
    private LinkedList<AbstractActionModel> onEntryActions;
    private LinkedList<ExceptionHandlerModel> exceptionHandlers;

    public AbstractStateModel(String id) {
        this.setId(id);
    }

    protected void fillCopy(AbstractStateModel copy) {
        copy.setParent(this.parent);
        copy.setAttributes(this.copyList(this.attributes));
        copy.setSecured((SecuredModel)this.copy(this.secured));
        copy.setOnEntryActions(this.copyList(this.onEntryActions));
        copy.setExceptionHandlers(this.copyList(this.exceptionHandlers));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StringUtils.hasText((String)id) ? id : null;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = StringUtils.hasText((String)parent) ? parent : null;
    }

    public LinkedList<AttributeModel> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList<AttributeModel> attributes) {
        this.attributes = attributes;
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public LinkedList<AbstractActionModel> getOnEntryActions() {
        return this.onEntryActions;
    }

    public void setOnEntryActions(LinkedList<AbstractActionModel> onEntryActions) {
        this.onEntryActions = onEntryActions;
    }

    public LinkedList<ExceptionHandlerModel> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(LinkedList<ExceptionHandlerModel> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }
}

