/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RestControllerEndpoint(id="sso", enableByDefault=false)
public class SingleSignOnSessionStatusEndpoint {
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final TicketRegistrySupport ticketRegistrySupport;

    @GetMapping(produces={"application/json"})
    @Operation(summary="Get current status of single sign-on", parameters={@Parameter(name="tgc", required=false), @Parameter(name="request", required=false)})
    public ResponseEntity<Map<?, ?>> ssoStatus(@RequestParam(name="tgc", required=false, defaultValue="") String tgc, HttpServletRequest request) {
        String tgtId;
        String string = tgtId = StringUtils.isNotBlank((CharSequence)tgc) ? this.ticketGrantingTicketCookieGenerator.getCasCookieValueManager().obtainCookieValue(tgc, request) : this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return ResponseEntity.badRequest().build();
        }
        Authentication auth = this.ticketRegistrySupport.getAuthenticationFrom(tgtId);
        if (auth == null) {
            return ResponseEntity.badRequest().build();
        }
        Ticket ticketState = this.ticketRegistrySupport.getTicket(tgtId);
        Map body = CollectionUtils.wrap((String)"principal", (Object)auth.getPrincipal().getId(), (String)"authenticationDate", (Object)auth.getAuthenticationDate(), (String)"ticketGrantingTicketCreationTime", (Object)ticketState.getCreationTime(), (String)"ticketGrantingTicketPreviousTimeUsed", (Object)ticketState.getPreviousTimeUsed(), (String)"ticketGrantingTicketLastTimeUsed", (Object)ticketState.getLastTimeUsed());
        return ResponseEntity.ok((Object)body);
    }

    @Generated
    public SingleSignOnSessionStatusEndpoint(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistrySupport ticketRegistrySupport) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }
}

