/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AttachmentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Object execute(CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        AttachmentEntity attachment = (AttachmentEntity)processEngineConfiguration.getAttachmentEntityManager().findById(this.attachmentId);
        String processInstanceId = attachment.getProcessInstanceId();
        String processDefinitionId = null;
        ExecutionEntity processInstance = null;
        if (attachment.getProcessInstanceId() != null && (processInstance = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(processInstanceId)) != null) {
            processDefinitionId = processInstance.getProcessDefinitionId();
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processInstance.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.deleteAttachment(this.attachmentId);
                return null;
            }
        }
        processEngineConfiguration.getAttachmentEntityManager().delete(attachment, false);
        if (attachment.getContentId() != null) {
            processEngineConfiguration.getByteArrayEntityManager().deleteByteArrayById(attachment.getContentId());
        }
        TaskEntity task = null;
        if (attachment.getTaskId() != null) {
            task = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(attachment.getTaskId());
        }
        if (attachment.getTaskId() != null) {
            processEngineConfiguration.getHistoryManager().createAttachmentComment(task, processInstance, attachment.getName(), false);
        }
        if ((eventDispatcher = processEngineConfiguration.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, attachment, processInstanceId, processInstanceId, processDefinitionId), processEngineConfiguration.getEngineCfgKey());
        }
        return null;
    }
}

