/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.authentication;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;

public class SamlIdPAuthenticationContext
implements Serializable {
    private static final long serialVersionUID = 696048495600124624L;
    private final Map<String, SamlIdPAuthenticationContext> contexts = new LinkedHashMap<String, SamlIdPAuthenticationContext>();
    private final Map<String, Serializable> properties = new LinkedHashMap<String, Serializable>();

    public static SamlIdPAuthenticationContext from(MessageContext context) {
        SamlIdPAuthenticationContext result = new SamlIdPAuthenticationContext();
        if (context.containsSubcontext(SAMLBindingContext.class)) {
            SAMLBindingContext binding = Objects.requireNonNull((SAMLBindingContext)context.getSubcontext(SAMLBindingContext.class));
            result.getSubcontext(SAMLBindingContext.class).put("relayState", (Serializable)((Object)binding.getRelayState()));
            result.getSubcontext(SAMLBindingContext.class).put("hasBindingSignature", Boolean.valueOf(binding.hasBindingSignature()));
        }
        if (context.containsSubcontext(SAMLProtocolContext.class)) {
            SAMLProtocolContext protocol = Objects.requireNonNull((SAMLProtocolContext)context.getSubcontext(SAMLProtocolContext.class));
            result.getSubcontext(SAMLProtocolContext.class).put("protocol", (Serializable)((Object)protocol.getProtocol()));
        }
        if (context.containsSubcontext(SAMLPeerEntityContext.class)) {
            SAMLPeerEntityContext peer = Objects.requireNonNull((SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class));
            result.getSubcontext(SAMLPeerEntityContext.class).put("entityId", (Serializable)((Object)peer.getEntityId()));
            result.getSubcontext(SAMLPeerEntityContext.class).put("authenticated", Boolean.valueOf(peer.isAuthenticated()));
        }
        return result;
    }

    public static SamlIdPAuthenticationContext decode(String data) {
        byte[] decoded = EncodingUtils.decodeBase64((String)data);
        return (SamlIdPAuthenticationContext)SerializationUtils.deserialize((byte[])decoded, SamlIdPAuthenticationContext.class);
    }

    public String encode() {
        return EncodingUtils.encodeBase64((byte[])SerializationUtils.serialize((Serializable)this));
    }

    public MessageContext toMessageContext(Object message) {
        SAMLBindingContext subcontext;
        SamlIdPAuthenticationContext binding;
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage(message);
        if (this.contexts.containsKey(SAMLBindingContext.class.getName())) {
            binding = this.contexts.get(SAMLBindingContext.class.getName());
            subcontext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
            subcontext.setHasBindingSignature(((Boolean)binding.properties.get("hasBindingSignature")).booleanValue());
            subcontext.setRelayState((String)((Object)binding.properties.get("relayState")));
        }
        if (this.contexts.containsKey(SAMLProtocolContext.class.getName())) {
            binding = this.contexts.get(SAMLProtocolContext.class.getName());
            subcontext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true);
            subcontext.setProtocol((String)((Object)binding.properties.get("protocol")));
        }
        if (this.contexts.containsKey(SAMLPeerEntityContext.class.getName())) {
            binding = this.contexts.get(SAMLPeerEntityContext.class.getName());
            subcontext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
            subcontext.setEntityId((String)((Object)binding.properties.get("entityId")));
        }
        return messageContext;
    }

    public SamlIdPAuthenticationContext getSubcontext(Class<? extends BaseContext> clazz) {
        if (!this.contexts.containsKey(clazz.getName())) {
            this.contexts.put(clazz.getName(), new SamlIdPAuthenticationContext());
        }
        return this.contexts.get(clazz.getName());
    }

    public void put(String name, Serializable value) {
        if (value != null) {
            this.properties.put(name, value);
        }
    }
}

