/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import com.yubico.u2f.U2F;
import org.apereo.cas.adaptors.u2f.U2FAuthenticationHandler;
import org.apereo.cas.adaptors.u2f.U2FMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.u2f.U2FTokenCredential;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.MultifactorAuthenticationFailureModeEvaluator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.handler.ByCredentialTypeAuthenticationHandlerResolver;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.MultifactorAuthenticationProviderMetadataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.U2F)
@AutoConfiguration
public class U2FAuthenticationEventExecutionPlanConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"u2fMultifactorProviderAuthenticationMetadataPopulator"})
    public AuthenticationMetaDataPopulator u2fMultifactorProviderAuthenticationMetadataPopulator(@Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="u2fMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> u2fMultifactorAuthenticationProvider) {
        String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        return new MultifactorAuthenticationProviderMetadataPopulator(authenticationContextAttribute, u2fMultifactorAuthenticationProvider, servicesManager);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"u2fAuthenticationMetaDataPopulator"})
    public AuthenticationMetaDataPopulator u2fAuthenticationMetaDataPopulator(CasConfigurationProperties casProperties, @Qualifier(value="u2fAuthenticationHandler") AuthenticationHandler u2fAuthenticationHandler, @Qualifier(value="u2fMultifactorAuthenticationProvider") MultifactorAuthenticationProvider u2fMultifactorAuthenticationProvider) {
        String authenticationContextAttribute = casProperties.getAuthn().getMfa().getCore().getAuthenticationContextAttribute();
        return new AuthenticationContextAttributeMetaDataPopulator(authenticationContextAttribute, u2fAuthenticationHandler, u2fMultifactorAuthenticationProvider.getId());
    }

    @ConditionalOnMissingBean(name={"u2fPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory u2fPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationHandler"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationHandler u2fAuthenticationHandler(CasConfigurationProperties casProperties, @Qualifier(value="u2fMultifactorAuthenticationProvider") ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider, @Qualifier(value="u2fPrincipalFactory") PrincipalFactory u2fPrincipalFactory, @Qualifier(value="u2fService") U2F u2fService, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="u2fDeviceRepository") U2FDeviceRepository u2fDeviceRepository) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        return new U2FAuthenticationHandler(u2f.getName(), servicesManager, u2fPrincipalFactory, u2fDeviceRepository, u2fService, Integer.valueOf(u2f.getOrder()), multifactorAuthenticationProvider);
    }

    @ConditionalOnMissingBean(name={"u2fMultifactorAuthenticationProvider"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProvider u2fMultifactorAuthenticationProvider(CasConfigurationProperties casProperties, @Qualifier(value="u2fBypassEvaluator") MultifactorAuthenticationProviderBypassEvaluator u2fBypassEvaluator, @Qualifier(value="failureModeEvaluator") MultifactorAuthenticationFailureModeEvaluator failureModeEvaluator) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        U2FMultifactorAuthenticationProvider p = new U2FMultifactorAuthenticationProvider();
        p.setBypassEvaluator(u2fBypassEvaluator);
        p.setFailureMode(u2f.getFailureMode());
        p.setFailureModeEvaluator(failureModeEvaluator);
        p.setOrder(u2f.getRank());
        p.setId(u2f.getId());
        return p;
    }

    @ConditionalOnMissingBean(name={"u2fAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer u2fAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="u2fMultifactorProviderAuthenticationMetadataPopulator") AuthenticationMetaDataPopulator u2fMultifactorProviderAuthenticationMetadataPopulator, @Qualifier(value="u2fAuthenticationHandler") AuthenticationHandler u2fAuthenticationHandler, @Qualifier(value="u2fAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator u2fAuthenticationMetaDataPopulator) {
        return plan -> {
            plan.registerAuthenticationHandler(u2fAuthenticationHandler);
            plan.registerAuthenticationMetadataPopulator(u2fAuthenticationMetaDataPopulator);
            plan.registerAuthenticationMetadataPopulator(u2fMultifactorProviderAuthenticationMetadataPopulator);
            plan.registerAuthenticationHandlerResolver((AuthenticationHandlerResolver)new ByCredentialTypeAuthenticationHandlerResolver(new Class[]{U2FTokenCredential.class}));
        };
    }
}

