/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.idm.api.Token;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.persistence.entity.TokenEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class SaveTokenCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected Token token;

    public SaveTokenCmd(Token token, IdmEngineConfiguration idmEngineConfiguration) {
        this.token = token;
        this.idmEngineConfiguration = idmEngineConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (this.token == null) {
            throw new FlowableIllegalArgumentException("token is null");
        }
        if (this.idmEngineConfiguration.getTokenEntityManager().isNewToken(this.token)) {
            if (this.token instanceof TokenEntity) {
                this.idmEngineConfiguration.getTokenEntityManager().insert((TokenEntity)this.token, true);
            } else {
                CommandContextUtil.getDbSqlSession(commandContext).insert((Entity)this.token, this.idmEngineConfiguration.getIdGenerator());
            }
        } else {
            this.idmEngineConfiguration.getTokenEntityManager().updateToken(this.token);
        }
        return null;
    }
}

