/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.configuration.model.core.monitor.JaasSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.core.monitor.LdapSecurityActuatorEndpointsMonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.ProtocolEndpointWebSecurityConfigurer;
import org.apereo.cas.web.security.authentication.EndpointLdapAuthenticationProvider;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.jaas.JaasAuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Order(value=1000)
public class CasWebSecurityConfigurerAdapter
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasWebSecurityConfigurerAdapter.class);
    public static final String ENDPOINT_URL_ADMIN_FORM_LOGIN = "/adminlogin";
    private final CasConfigurationProperties casProperties;
    private final SecurityProperties securityProperties;
    private final ObjectProvider<PathMappedEndpoints> pathMappedEndpoints;
    private final List<ProtocolEndpointWebSecurityConfigurer> protocolEndpointWebSecurityConfigurers;
    private final SecurityContextRepository securityContextRepository;
    private EndpointLdapAuthenticationProvider endpointLdapAuthenticationProvider;

    public void destroy() {
        FunctionUtils.doIfNotNull((Object)this.endpointLdapAuthenticationProvider, EndpointLdapAuthenticationProvider::destroy);
    }

    public void configureWebSecurity(WebSecurity web) {
        List patterns = this.protocolEndpointWebSecurityConfigurers.stream().map(ProtocolEndpointWebSecurityConfigurer::getIgnoredEndpoints).flatMap(Collection::stream).map(endpoint -> StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("/**")).collect(Collectors.toList());
        patterns.add("/webjars/**");
        patterns.add("/js/**");
        patterns.add("/css/**");
        patterns.add("/images/**");
        patterns.add("/static/**");
        patterns.add("/error");
        patterns.add("/favicon.ico");
        LOGGER.debug("Configuring protocol endpoints [{}] to exclude/ignore from web security", patterns);
        web.debug(LOGGER.isDebugEnabled()).ignoring().antMatchers((String[])patterns.toArray(String[]::new));
    }

    public HttpSecurity configureHttpSecurity(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ChannelSecurityConfigurer.RequiresChannelUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors(Customizer.withDefaults()).csrf().disable()).headers().disable()).logout().disable()).requiresChannel().requestMatchers(new RequestMatcher[]{r -> r.getHeader("X-Forwarded-Proto") != null})).requiresSecure().and()).securityContext(customizer -> customizer.securityContextRepository(this.securityContextRepository));
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests = http.authorizeHttpRequests();
        List patterns = this.protocolEndpointWebSecurityConfigurers.stream().map(ProtocolEndpointWebSecurityConfigurer::getIgnoredEndpoints).flatMap(Collection::stream).map(endpoint -> StringUtils.prependIfMissing((String)endpoint, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat("/**")).collect(Collectors.toList());
        patterns.add("/webjars/**");
        patterns.add("/js/**");
        patterns.add("/css/**");
        patterns.add("/images/**");
        patterns.add("/static/**");
        patterns.add("/error");
        patterns.add("/favicon.ico");
        LOGGER.debug("Configuring protocol endpoints [{}] to exclude/ignore from web security", patterns);
        ((HttpSecurity)((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.antMatchers((String[])patterns.toArray(String[]::new))).permitAll().and()).securityContext(customizer -> customizer.securityContextRepository(this.securityContextRepository)).sessionManagement().disable()).requestCache().disable();
        this.protocolEndpointWebSecurityConfigurers.forEach(cfg -> cfg.configure((Object)http));
        Map endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint();
        endpoints.forEach(Unchecked.biConsumer((key, v) -> {
            EndpointRequest.EndpointRequestMatcher endpoint = EndpointRequest.to((String[])new String[]{key});
            v.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, (ActuatorEndpointProperties)v, endpoint)));
        }));
        this.configureEndpointAccessToDenyUndefined(http, requests);
        this.configureEndpointAccessForStaticResources(requests);
        this.configureEndpointAccessByFormLogin(http);
        JaasSecurityActuatorEndpointsMonitorProperties jaas = this.casProperties.getMonitor().getEndpoints().getJaas();
        if (jaas.getLoginConfig() != null) {
            CasWebSecurityConfigurerAdapter.configureJaasAuthenticationProvider(http, jaas);
        } else {
            LOGGER.trace("No JAAS login config is defined to enable JAAS authentication");
        }
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        if (StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
            this.configureLdapAuthenticationProvider(http, ldap);
        } else {
            LOGGER.trace("No LDAP url or search filter is defined to enable LDAP authentication");
        }
        return http;
    }

    protected void configureEndpointAccessToDenyUndefined(HttpSecurity http, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests) {
        Set endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint().keySet();
        ActuatorEndpointProperties endpointDefaults = this.casProperties.getMonitor().getEndpoints().getDefaultEndpointProperties();
        ((PathMappedEndpoints)this.pathMappedEndpoints.getObject()).forEach(endpoint -> {
            String rootPath = endpoint.getRootPath();
            if (endpoints.contains(rootPath)) {
                LOGGER.trace("Endpoint security is defined for endpoint [{}]", (Object)rootPath);
            } else {
                List defaultAccessRules = endpointDefaults.getAccess();
                LOGGER.trace("Endpoint security is NOT defined for endpoint [{}]. Using default security rules [{}]", (Object)rootPath, (Object)endpointDefaults);
                EndpointRequest.EndpointRequestMatcher endpointRequest = EndpointRequest.to((String[])new String[]{rootPath}).excludingLinks();
                defaultAccessRules.forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, endpointDefaults, endpointRequest)));
            }
        });
    }

    protected void configureEndpointAccessForStaticResources(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/resources/**"})).permitAll().antMatchers(new String[]{"/static/**"})).permitAll();
    }

    protected void configureEndpointAccessByFormLogin(HttpSecurity http) throws Exception {
        if (this.casProperties.getMonitor().getEndpoints().isFormLoginEnabled()) {
            http.formLogin().loginPage(ENDPOINT_URL_ADMIN_FORM_LOGIN).permitAll();
        } else {
            http.formLogin().disable();
        }
    }

    protected void configureEndpointAccess(HttpSecurity httpSecurity, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, ActuatorEndpointProperties.EndpointAccessLevel access, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        switch (access) {
            case AUTHORITY: {
                this.configureEndpointAccessByAuthority(httpSecurity, requests, properties, endpoint);
                break;
            }
            case ROLE: {
                this.configureEndpointAccessByRole(httpSecurity, requests, properties, endpoint);
                break;
            }
            case AUTHENTICATED: {
                this.configureEndpointAccessAuthenticated(httpSecurity, requests, endpoint);
                break;
            }
            case IP_ADDRESS: {
                this.configureEndpointAccessByIpAddress(requests, properties, endpoint);
                break;
            }
            case PERMIT: {
                this.configureEndpointAccessPermitAll(requests, endpoint);
                break;
            }
            case ANONYMOUS: {
                this.configureEndpointAccessAnonymously(requests, endpoint);
                break;
            }
            default: {
                this.configureEndpointAccessToDenyAll(requests, endpoint);
            }
        }
    }

    protected void configureEndpointAccessPermitAll(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).permitAll();
    }

    protected void configureEndpointAccessToDenyAll(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).denyAll();
    }

    protected void configureEndpointAccessAnonymously(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).permitAll();
    }

    protected void configureEndpointAccessByIpAddress(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).access((authentication, context) -> {
            String remoteAddr = (String)StringUtils.defaultIfBlank((CharSequence)context.getRequest().getHeader(this.casProperties.getAudit().getEngine().getAlternateClientAddrHeaderName()), (CharSequence)context.getRequest().getRemoteAddr());
            Optional<String> addresses = properties.getRequiredIpAddresses().stream().filter(add -> {
                try {
                    IpAddressMatcher ipAddressMatcher = new IpAddressMatcher(add);
                    LOGGER.trace("Attempting to match [{}] against [{}] as a IP or netmask", (Object)remoteAddr, add);
                    return ipAddressMatcher.matches(remoteAddr);
                }
                catch (Exception e) {
                    LOGGER.trace("Falling back to regex match. Couldn't treat [{}] as an IP address or netmask: [{}]", add, (Object)e.getMessage());
                    Matcher matcher = RegexUtils.createPattern((String)add, (int)2).matcher(remoteAddr);
                    LOGGER.trace("Attempting to match [{}] against [{}] as a regular expression", (Object)remoteAddr, add);
                    return matcher.find();
                }
            }).findFirst();
            boolean granted = addresses.isPresent();
            if (!granted) {
                LOGGER.warn("Provided regular expression or IP/netmask [{}] does not match [{}]", (Object)properties.getRequiredIpAddresses(), (Object)remoteAddr);
            }
            return new AuthorizationDecision(granted);
        });
    }

    protected void configureEndpointAccessAuthenticated(HttpSecurity http, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).authenticated().and()).httpBasic();
    }

    protected void configureEndpointAccessByRole(HttpSecurity http, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyRole(properties.getRequiredRoles().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic();
    }

    protected void configureEndpointAccessByAuthority(HttpSecurity http, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyAuthority(properties.getRequiredAuthorities().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic();
    }

    private boolean isLdapAuthorizationActive() {
        LdapSecurityActuatorEndpointsMonitorProperties ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        return StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter()) && (StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getRoleAttribute()) || StringUtils.isNotBlank((CharSequence)ldap.getLdapAuthz().getGroupAttribute()));
    }

    private static void configureJaasAuthenticationProvider(HttpSecurity http, JaasSecurityActuatorEndpointsMonitorProperties jaas) throws Exception {
        JaasAuthenticationProvider p = new JaasAuthenticationProvider();
        p.setLoginConfig(jaas.getLoginConfig());
        p.setLoginContextName(jaas.getLoginContextName());
        p.setRefreshConfigurationOnStartup(jaas.isRefreshConfigurationOnStartup());
        p.afterPropertiesSet();
        http.authenticationProvider((AuthenticationProvider)p);
    }

    private void configureLdapAuthenticationProvider(HttpSecurity http, LdapSecurityActuatorEndpointsMonitorProperties ldap) {
        if (this.isLdapAuthorizationActive()) {
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)ldap);
            this.endpointLdapAuthenticationProvider = new EndpointLdapAuthenticationProvider(ldap, this.securityProperties, connectionFactory, authenticator);
            http.authenticationProvider((AuthenticationProvider)this.endpointLdapAuthenticationProvider);
        }
    }

    @Generated
    public CasWebSecurityConfigurerAdapter(CasConfigurationProperties casProperties, SecurityProperties securityProperties, ObjectProvider<PathMappedEndpoints> pathMappedEndpoints, List<ProtocolEndpointWebSecurityConfigurer> protocolEndpointWebSecurityConfigurers, SecurityContextRepository securityContextRepository) {
        this.casProperties = casProperties;
        this.securityProperties = securityProperties;
        this.pathMappedEndpoints = pathMappedEndpoints;
        this.protocolEndpointWebSecurityConfigurers = protocolEndpointWebSecurityConfigurers;
        this.securityContextRepository = securityContextRepository;
    }
}

