/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;

public enum ContentSyncState {
    PRESENT(0),
    ADD(1),
    MODIFY(2),
    DELETE(3);

    private final int intValue;

    private ContentSyncState(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static ContentSyncState valueOf(int intValue) {
        if (intValue == PRESENT.intValue()) {
            return PRESENT;
        }
        if (intValue == ADD.intValue()) {
            return ADD;
        }
        if (intValue == MODIFY.intValue()) {
            return MODIFY;
        }
        if (intValue == DELETE.intValue()) {
            return DELETE;
        }
        return null;
    }

    @Nullable
    public static ContentSyncState forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "present": {
                return PRESENT;
            }
            case "add": {
                return ADD;
            }
            case "modify": {
                return MODIFY;
            }
            case "delete": {
                return DELETE;
            }
        }
        return null;
    }
}

