/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

public class SubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;

    public SubmitLink(String id) {
        super(id);
    }

    public SubmitLink(String id, Form<?> form) {
        super(id, form);
    }

    public SubmitLink(String id, IModel<?> model) {
        super(id, model);
    }

    public SubmitLink(String id, IModel<?> model, Form<?> form) {
        super(id, model, form);
    }

    public final void onLinkClicked() {
        this.onSubmit();
        this.onAfterSubmit();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnabledInHierarchy()) {
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", "#");
            } else if (tag.getName().equalsIgnoreCase("button")) {
                tag.put("type", "button");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.isEnabledInHierarchy()) {
            response.render(OnEventHeaderItem.forComponent(this, "click", this.getTriggerJavaScript()));
        }
    }

    protected boolean shouldTriggerJavaScriptSubmitEvent() {
        return true;
    }

    protected CharSequence getTriggerJavaScript() {
        if (this.getForm() != null) {
            Form<?> root = this.getForm().getRootForm();
            StringBuilder script = new StringBuilder();
            script.append(root.getJsForSubmitter(this, this.shouldTriggerJavaScriptSubmitEvent()));
            script.append("return false;");
            return script;
        }
        return null;
    }

    @Override
    public void onError() {
    }

    @Override
    public void onAfterSubmit() {
    }

    @Override
    public void onSubmit() {
    }
}

