/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.UUID;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class VariableLoggingSessionUtil {
    public static ObjectNode addLoggingData(String message, VariableInstanceEntity variableInstance, ObjectMapper objectMapper) {
        String subScopeId;
        ObjectNode loggingNode = null;
        if (variableInstance.getScopeId() != null && "cmmn".equals(variableInstance.getScopeType())) {
            subScopeId = null;
            if (!variableInstance.getScopeId().equals(variableInstance.getSubScopeId())) {
                subScopeId = variableInstance.getSubScopeId();
            }
            loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)variableInstance.getScopeId(), (String)subScopeId, (String)"cmmn", (ObjectMapper)objectMapper);
        } else if (variableInstance.getProcessInstanceId() != null) {
            subScopeId = null;
            if (!variableInstance.getProcessInstanceId().equals(variableInstance.getExecutionId())) {
                subScopeId = variableInstance.getExecutionId();
            }
            loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)variableInstance.getProcessInstanceId(), (String)subScopeId, (String)"bpmn", (ObjectMapper)objectMapper);
        }
        if (loggingNode != null) {
            loggingNode.put("variableName", variableInstance.getName());
            String variableTypeName = variableInstance.getType().getTypeName();
            loggingNode.put("variableType", variableTypeName);
            if (variableInstance.getValue() == null) {
                loggingNode.putNull("variableRawValue");
                loggingNode.putNull("variableValue");
            } else {
                VariableLoggingSessionUtil.addVariableValue(variableInstance.getValue(), variableTypeName, "variableRawValue", "variableValue", loggingNode);
            }
        }
        return loggingNode;
    }

    public static void addVariableValue(Object variableValue, String variableTypeName, String variableRawValueName, String variableValueName, ObjectNode loggingNode) {
        if ("long".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (Long)variableValue);
        } else if ("integer".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (Integer)variableValue);
        } else if ("double".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (Double)variableValue);
        } else if ("short".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (Short)variableValue);
        } else if ("date".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, LoggingSessionUtil.formatDate((Date)((Date)variableValue)));
        } else if ("jodadatetime".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, LoggingSessionUtil.formatDate((DateTime)((DateTime)variableValue)));
        } else if ("jodadate".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, LoggingSessionUtil.formatDate((LocalDate)((LocalDate)variableValue)));
        } else if ("boolean".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (Boolean)variableValue);
        } else if ("json".equals(variableTypeName)) {
            loggingNode.set(variableRawValueName, (JsonNode)variableValue);
        } else if ("uuid".equals(variableTypeName)) {
            loggingNode.put("variableRawValue", ((UUID)variableValue).toString());
        } else if ("null".equals(variableTypeName)) {
            loggingNode.putNull(variableRawValueName);
        } else if ("string".equals(variableTypeName)) {
            loggingNode.put(variableRawValueName, (String)variableValue);
        } else {
            return;
        }
        if ("date".equals(variableTypeName)) {
            loggingNode.put(variableValueName, LoggingSessionUtil.formatDate((Date)((Date)variableValue)));
        } else if ("jodadatetime".equals(variableTypeName)) {
            loggingNode.put(variableValueName, LoggingSessionUtil.formatDate((DateTime)((DateTime)variableValue)));
        } else if ("jodadate".equals(variableTypeName)) {
            loggingNode.put(variableValueName, LoggingSessionUtil.formatDate((LocalDate)((LocalDate)variableValue)));
        } else {
            loggingNode.put(variableValueName, String.valueOf(variableValue));
        }
    }
}

