/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public class FlowResourceFlowViewResolver
implements FlowViewResolver {
    private static final boolean JSTL_PRESENT = ClassUtils.isPresent((String)"jakarta.servlet.jsp.jstl.fmt.LocalizationContext", (ClassLoader)FlowResourceFlowViewResolver.class.getClassLoader());
    private String defaultViewSuffix = ".jsp";

    public String getDefaultViewSuffix() {
        return this.defaultViewSuffix;
    }

    public void setDefaultViewSuffix(String defaultViewSuffix) {
        this.defaultViewSuffix = defaultViewSuffix;
    }

    @Override
    public View resolveView(String viewId, RequestContext context) {
        if (viewId.startsWith("/")) {
            return this.getViewInternal(viewId, context, context.getActiveFlow().getApplicationContext());
        }
        ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
        if (flowContext == null) {
            throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
        }
        Resource viewResource = flowContext.getResource(viewId);
        if (!(viewResource instanceof ContextResource)) {
            throw new IllegalStateException("A ContextResource is required to get relative view paths within this context");
        }
        return this.getViewInternal(((ContextResource)viewResource).getPathWithinContext(), context, flowContext);
    }

    @Override
    public String getViewIdByConvention(String viewStateId) {
        return viewStateId + this.defaultViewSuffix;
    }

    private View getViewInternal(String viewPath, RequestContext context, ApplicationContext flowContext) {
        if (viewPath.endsWith(".jsp") || viewPath.endsWith(".jspx")) {
            if (JSTL_PRESENT) {
                JstlView view = new JstlView(viewPath);
                view.setApplicationContext(flowContext);
                return view;
            }
            InternalResourceView view = new InternalResourceView(viewPath);
            view.setApplicationContext(flowContext);
            return view;
        }
        throw new IllegalArgumentException("Unsupported view type " + viewPath + " only types supported by this FlowViewResolver implementation are [.jsp] and [.jspx]");
    }
}

