/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultEntry
extends ReadOnlyEntry
implements LDAPResponse {
    private static final long serialVersionUID = -290721544252526163L;
    @NotNull
    private final Control[] controls;
    private final int messageID;

    public SearchResultEntry(@NotNull String dn, @NotNull Attribute[] attributes, Control ... controls) {
        this(-1, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, @NotNull String dn, @NotNull Attribute[] attributes, Control ... controls) {
        this(messageID, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, @NotNull String dn, @Nullable Schema schema, @NotNull Attribute[] attributes, Control ... controls) {
        super(dn, schema, attributes);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    public SearchResultEntry(@NotNull String dn, @NotNull Collection<Attribute> attributes, Control ... controls) {
        this(-1, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, @NotNull String dn, @NotNull Collection<Attribute> attributes, Control ... controls) {
        this(messageID, dn, null, attributes, controls);
    }

    public SearchResultEntry(int messageID, @NotNull String dn, @Nullable Schema schema, @NotNull Collection<Attribute> attributes, Control ... controls) {
        super(dn, schema, attributes);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    public SearchResultEntry(@NotNull Entry entry, Control ... controls) {
        this(-1, entry, controls);
    }

    public SearchResultEntry(int messageID, @NotNull Entry entry, Control ... controls) {
        super(entry);
        Validator.ensureNotNull(controls);
        this.messageID = messageID;
        this.controls = controls;
    }

    @NotNull
    static SearchResultEntry readSearchEntryFrom(int messageID, @NotNull ASN1StreamReaderSequence messageSequence, @NotNull ASN1StreamReader reader, @Nullable Schema schema) throws LDAPException {
        try {
            reader.beginSequence();
            String dn = reader.readString();
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence attrSequence = reader.beginSequence();
            while (attrSequence.hasMoreElements()) {
                attrList.add(Attribute.readFrom(reader, schema));
            }
            Control[] controls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(5);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            }
            return new SearchResultEntry(messageID, dn, schema, attrList, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_SEARCH_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getMessageID() {
        return this.messageID;
    }

    @NotNull
    public Control[] getControls() {
        return this.controls;
    }

    @Nullable
    public Control getControl(@NotNull String oid) {
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SearchResultEntry)) {
            return true;
        }
        SearchResultEntry e = (SearchResultEntry)o;
        if (this.controls.length != e.controls.length) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (this.controls[i].equals(e.controls[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SearchResultEntry(dn='");
        buffer.append(this.getDN());
        buffer.append('\'');
        if (this.messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(this.messageID);
        }
        buffer.append(", attributes={");
        Iterator<Attribute> iterator = this.getAttributes().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, controls={");
        for (int i = 0; i < this.controls.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.controls[i].toString(buffer);
        }
        buffer.append("})");
    }
}

