/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.X509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509ExtractorUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.X509UPNExtractorUtils;
import org.apereo.cas.util.CollectionUtils;

public class DefaultX509AttributeExtractor
implements X509AttributeExtractor {
    @Override
    public Map<String, List<Object>> extractPersonAttributes(X509Certificate certificate) {
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        if (certificate != null) {
            X500Principal issuerPrincipal;
            Principal issuerDn;
            X500Principal subjectPrincipal;
            Principal subjectDn;
            if (StringUtils.isNotBlank((CharSequence)certificate.getSigAlgOID())) {
                attributes.put("sigAlgOid", CollectionUtils.wrapList((Object[])new Object[]{certificate.getSigAlgOID()}));
            }
            if ((subjectDn = certificate.getSubjectDN()) != null) {
                attributes.put("subjectDn", CollectionUtils.wrapList((Object[])new Object[]{subjectDn.getName()}));
            }
            if ((subjectPrincipal = certificate.getSubjectX500Principal()) != null) {
                attributes.put("subjectX500Principal", CollectionUtils.wrapList((Object[])new Object[]{subjectPrincipal.getName()}));
            }
            if ((issuerDn = certificate.getIssuerDN()) != null) {
                attributes.put("issuerDn", CollectionUtils.wrapList((Object[])new Object[]{issuerDn.getName()}));
            }
            if ((issuerPrincipal = certificate.getIssuerX500Principal()) != null) {
                attributes.put("issuerX500Principal", CollectionUtils.wrapList((Object[])new Object[]{issuerPrincipal.getName()}));
            }
            Collection<List<?>> subjectAltNames = X509ExtractorUtils.getSubjectAltNames(certificate);
            X509ExtractorUtils.getRFC822EmailAddress(subjectAltNames).ifPresent(email -> attributes.put("x509Rfc822Email", CollectionUtils.wrapList((Object[])new Object[]{email})));
            X509UPNExtractorUtils.extractUPNString(subjectAltNames).ifPresent(upn -> attributes.put("x509subjectUPN", CollectionUtils.wrapList((Object[])new Object[]{upn})));
        }
        return attributes;
    }
}

