/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);

    public static Document newDocument(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        for (Map.Entry entry : features.entrySet()) {
            try {
                factory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
            catch (ParserConfigurationException e) {
                LOGGER.warn("Failed setting XML feature {}", entry.getKey(), (Object)e);
            }
        }
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("XML parsing error: " + e);
        }
    }

    public static XMLReader getXmlReader() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create XMLReader", e);
        }
    }

    public static List<String> getTextForElements(String xmlAsString, final String element) {
        final ArrayList<String> elements = new ArrayList<String>(2);
        XMLReader reader = XmlUtils.getXmlReader();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;
            private StringBuilder buffer = new StringBuilder();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (localName.equals(element)) {
                    this.foundElement = false;
                    elements.add(this.buffer.toString());
                    this.buffer = new StringBuilder();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this.foundElement) {
                    this.buffer.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return elements;
    }

    public static String getTextForElement(String xmlAsString, final String element) {
        XMLReader reader = XmlUtils.getXmlReader();
        final StringBuilder builder = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = false;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    builder.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return builder.toString();
    }
}

