/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.framework.impl.api.BufferedResultsProxy;
import org.identityconnectors.framework.impl.api.MethodTimeoutProxy;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;

public class DelegatingTimeoutProxy
implements InvocationHandler {
    private final Object target;
    private final long timeoutMillis;
    private final int bufferSize;

    public DelegatingTimeoutProxy(Object target, long timeoutMillis, int bufferSize) {
        this.target = target;
        this.timeoutMillis = timeoutMillis;
        this.bufferSize = bufferSize;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.target, args);
        }
        InvocationHandler handler = null;
        if (this.isStreamHandlerMethod(method)) {
            if (this.timeoutMillis != -1L || this.bufferSize != 0) {
                handler = new BufferedResultsProxy(this.target, this.bufferSize, this.timeoutMillis);
            }
        } else if (this.timeoutMillis != -1L) {
            handler = new MethodTimeoutProxy(this.target, this.timeoutMillis);
        }
        if (handler != null) {
            return handler.invoke(proxy, method, args);
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private boolean isStreamHandlerMethod(Method method) {
        for (Class<?> paramType : method.getParameterTypes()) {
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) continue;
            return true;
        }
        return false;
    }
}

