/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.StartsWithRegisteredServiceMatchingStrategy;
import org.apereo.cas.support.oauth.services.OAuth20ServiceRegistry;
import org.apereo.cas.support.oauth.services.OAuth20ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OAuth})
@Configuration(value="CasOAuth20ServicesConfiguration", proxyBeanMethods=false)
class CasOAuth20ServicesConfiguration {
    CasOAuth20ServicesConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oauthServiceRegistryExecutionPlanConfigurer"})
    public ServiceRegistryExecutionPlanConfigurer oauthServiceRegistryExecutionPlanConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        return plan -> {
            String oAuthCallbackUrl = "^" + casProperties.getServer().getPrefix() + "/oauth2.0/callbackAuthorize.*";
            CasRegisteredService service = new CasRegisteredService();
            service.setEvaluationOrder(Integer.MIN_VALUE);
            service.setName(service.getClass().getSimpleName());
            service.setDescription("OAuth Authentication Callback Request URL");
            service.setServiceId(oAuthCallbackUrl);
            service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new DenyAllAttributeReleasePolicy());
            StartsWithRegisteredServiceMatchingStrategy matchingStrategy = new StartsWithRegisteredServiceMatchingStrategy();
            matchingStrategy.setExpectedUrl(casProperties.getServer().getPrefix());
            service.setMatchingStrategy((RegisteredServiceMatchingStrategy)matchingStrategy);
            service.markAsInternal();
            plan.registerServiceRegistry((ServiceRegistry)new OAuth20ServiceRegistry(applicationContext, new RegisteredService[]{service}));
        };
    }

    @Configuration(value="CasOAuth20ServicesCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=-2147483648)
    static class CasOAuth20ServicesCoreConfiguration {
        CasOAuth20ServicesCoreConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauthServicesManagerRegisteredServiceLocator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServicesManagerRegisteredServiceLocator oauthServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
            return new OAuth20ServicesManagerRegisteredServiceLocator(casProperties);
        }
    }
}

