/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import java.io.Serializable;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;

public class OAuth20RegisteredServiceCipherExecutor
extends BaseStringCipherExecutor {
    public static final String ENCRYPTED_VALUE_PREFIX = "{cas-cipher}";

    public OAuth20RegisteredServiceCipherExecutor(String secretKeyEncryption, String secretKeySigning, String alg, boolean encryptionEnabled, boolean signingEnabled, int signingKeySize, int encryptionKeySize) {
        super(secretKeyEncryption, secretKeySigning, alg, encryptionEnabled, signingEnabled, signingKeySize, encryptionKeySize);
    }

    public OAuth20RegisteredServiceCipherExecutor() {
        super(null, null, 0, 0);
    }

    public String getName() {
        return "OAuth Registered Service";
    }

    public String decode(Serializable value, Object[] parameters) {
        String currentValue = value.toString();
        if (currentValue.startsWith(ENCRYPTED_VALUE_PREFIX)) {
            currentValue = currentValue.substring(ENCRYPTED_VALUE_PREFIX.length());
            return super.decode((Serializable)((Object)currentValue), parameters);
        }
        return currentValue;
    }

    public String encode(Serializable value, Object[] parameters) {
        return ENCRYPTED_VALUE_PREFIX + super.encode(value, parameters);
    }

    public String getEncryptionKeySetting() {
        return "cas.authn.oauth.crypto.encryption.key";
    }

    public String getSigningKeySetting() {
        return "cas.authn.oauth.crypto.signing.key";
    }
}

