/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource.locator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.resource.locator.EmptyResourceNameIterator;
import org.apache.wicket.core.util.resource.locator.IResourceNameIterator;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceUtils;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamLocator
implements IResourceStreamLocator {
    private static final Logger log = LoggerFactory.getLogger(ResourceStreamLocator.class);
    private static final Iterable<String> NO_EXTENSIONS = new ArrayList<String>(0);
    private List<IResourceFinder> finders;

    public ResourceStreamLocator() {
        this((List<IResourceFinder>)null);
    }

    public ResourceStreamLocator(IResourceFinder ... finders) {
        this(Arrays.asList(finders));
    }

    public ResourceStreamLocator(List<IResourceFinder> finders) {
        this.finders = finders;
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path) {
        if (this.finders == null) {
            this.finders = Application.get().getResourceSettings().getResourceFinders();
        }
        for (IResourceFinder finder : this.finders) {
            log.debug("Attempting to locate resource '{}' using finder'{}'", (Object)path, (Object)finder);
            IResourceStream result = finder.find(clazz, path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        ResourceUtils.PathLocale data = ResourceUtils.getLocaleFromFilename((String)path);
        if (data != null && data.locale != null) {
            path = data.path;
            locale = data.locale;
        }
        IResourceNameIterator iter = this.newResourceNameIterator(path, locale, style, variation, extension, strict);
        while (iter.hasNext()) {
            String newPath = (String)iter.next();
            IResourceStream stream = this.locate(clazz, newPath);
            if (stream == null) continue;
            stream.setLocale(iter.getLocale());
            stream.setStyle(iter.getStyle());
            stream.setVariation(iter.getVariation());
            return stream;
        }
        return null;
    }

    @Override
    public IResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, String extension, boolean strict) {
        Iterable<String> extensions;
        String realPath;
        if (extension == null && path != null && path.indexOf(46) != -1) {
            realPath = Strings.beforeLast((String)path, (char)'.');
            String realExtension = Strings.afterLast((String)path, (char)'.');
            if (realExtension.indexOf(44) > -1) {
                return new EmptyResourceNameIterator();
            }
            extensions = Application.exists() && Application.get().getResourceSettings().getUseMinifiedResources() ? Arrays.asList("min." + realExtension, realExtension) : Collections.singleton(realExtension);
        } else {
            realPath = path;
            if (extension == null) {
                extensions = NO_EXTENSIONS;
            } else {
                String[] commaSeparated = Strings.split((String)extension, (char)',');
                List<String> nonMinifiedExtensions = Arrays.asList(commaSeparated);
                if (Application.exists() && Application.get().getResourceSettings().getUseMinifiedResources()) {
                    ArrayList<String> minifiedExtensions = new ArrayList<String>();
                    for (String nonMinifiedExtension : nonMinifiedExtensions) {
                        minifiedExtensions.add("min." + nonMinifiedExtension);
                        minifiedExtensions.add(nonMinifiedExtension);
                    }
                    extensions = minifiedExtensions;
                } else {
                    extensions = nonMinifiedExtensions;
                }
            }
        }
        return this.newResourceNameIterator(realPath, locale, style, variation, extensions, strict);
    }

    public IResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, Iterable<String> extensions, boolean strict) {
        return new ResourceNameIterator(path, style, variation, locale, extensions, strict);
    }
}

