/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.web.CasThymeleafViewResolverConfigurer;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.thymeleaf.spring6.view.AbstractThymeleafView;

public class ThemeViewResolver
extends AbstractCachingViewResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeViewResolver.class);
    private final ViewResolver delegate;
    private final ThymeleafProperties thymeleafProperties;
    private final String theme;
    private final List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers;

    @Nonnull
    protected Object getCacheKey(@Nonnull String viewName, @Nonnull Locale locale) {
        return String.format("%s#%s", this.theme, super.getCacheKey(viewName, locale));
    }

    protected View loadView(@Nonnull String viewName, @Nonnull Locale locale) throws Exception {
        View view;
        LOGGER.trace("Attempting to resolve view [{}] via locale [{}]", (Object)viewName, (Object)locale);
        ApplicationContext applicationContext = this.obtainApplicationContext();
        View view2 = view = applicationContext.containsBean(viewName) ? (View)applicationContext.getBean(viewName, View.class) : this.delegate.resolveViewName(viewName, locale);
        if (view instanceof AbstractThymeleafView) {
            AbstractThymeleafView thymeleafView = (AbstractThymeleafView)view;
            this.configureTemplateThemeDefaultLocation(thymeleafView);
            this.thymeleafViewResolverConfigurers.stream().sorted(OrderComparator.INSTANCE).forEach(configurer -> configurer.configureThymeleafView(thymeleafView));
        }
        return view;
    }

    private void configureTemplateThemeDefaultLocation(AbstractThymeleafView thymeleafView) {
        String baseTemplateName = thymeleafView.getTemplateName();
        String templateName = this.theme + "/" + baseTemplateName;
        String path = this.thymeleafProperties.getPrefix().concat(templateName).concat(this.thymeleafProperties.getSuffix());
        LOGGER.trace("Attempting to locate theme location at [{}]", (Object)path);
        TemplateLocation location = new TemplateLocation(path);
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null && location.exists((ResourcePatternResolver)applicationContext)) {
            thymeleafView.setTemplateName(templateName);
        }
    }

    @Generated
    public ThemeViewResolver(ViewResolver delegate, ThymeleafProperties thymeleafProperties, String theme, List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers) {
        this.delegate = delegate;
        this.thymeleafProperties = thymeleafProperties;
        this.theme = theme;
        this.thymeleafViewResolverConfigurers = thymeleafViewResolverConfigurers;
    }

    public static class Factory
    implements ThemeViewResolverFactory,
    ApplicationContextAware {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(Factory.class);
        private final ViewResolver delegate;
        private final ThymeleafProperties thymeleafProperties;
        private final CasConfigurationProperties casProperties;
        private final List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers;
        private ApplicationContext applicationContext;

        public ThemeViewResolver create(String theme) {
            LOGGER.trace("Creating theme view resolver based on theme [{}]", (Object)theme);
            ThemeViewResolver resolver = new ThemeViewResolver(this.delegate, this.thymeleafProperties, theme, this.thymeleafViewResolverConfigurers);
            resolver.setApplicationContext(this.applicationContext);
            resolver.setCache(this.thymeleafProperties.isCache());
            return resolver;
        }

        @Generated
        public ViewResolver getDelegate() {
            return this.delegate;
        }

        @Generated
        public ThymeleafProperties getThymeleafProperties() {
            return this.thymeleafProperties;
        }

        @Generated
        public CasConfigurationProperties getCasProperties() {
            return this.casProperties;
        }

        @Generated
        public List<CasThymeleafViewResolverConfigurer> getThymeleafViewResolverConfigurers() {
            return this.thymeleafViewResolverConfigurers;
        }

        @Generated
        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        @Generated
        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Generated
        public Factory(ViewResolver delegate, ThymeleafProperties thymeleafProperties, CasConfigurationProperties casProperties, List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers) {
            this.delegate = delegate;
            this.thymeleafProperties = thymeleafProperties;
            this.casProperties = casProperties;
            this.thymeleafViewResolverConfigurers = thymeleafViewResolverConfigurers;
        }
    }
}

