/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ResourceLogic
extends AbstractTransactionalLogic<ResourceTO> {
    protected final ExternalResourceDAO resourceDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ConnInstanceDAO connInstanceDAO;
    protected final ResourceDataBinder binder;
    protected final ConnInstanceDataBinder connInstanceDataBinder;
    protected final OutboundMatcher outboundMatcher;
    protected final MappingManager mappingManager;
    protected final ConnectorManager connectorManager;
    protected final AnyUtilsFactory anyUtilsFactory;

    public ResourceLogic(ExternalResourceDAO resourceDAO, AnyTypeDAO anyTypeDAO, ConnInstanceDAO connInstanceDAO, ResourceDataBinder binder, ConnInstanceDataBinder connInstanceDataBinder, OutboundMatcher outboundMatcher, MappingManager mappingManager, ConnectorManager connectorManager, AnyUtilsFactory anyUtilsFactory) {
        this.resourceDAO = resourceDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.connInstanceDAO = connInstanceDAO;
        this.binder = binder;
        this.connInstanceDataBinder = connInstanceDataBinder;
        this.outboundMatcher = outboundMatcher;
        this.mappingManager = mappingManager;
        this.connectorManager = connectorManager;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    protected void securityChecks(Set<String> effectiveRealms, String realm, String key) {
        boolean authorized = effectiveRealms.stream().anyMatch(realm::startsWith);
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, ExternalResource.class.getSimpleName(), key);
        }
    }

    protected ExternalResource doSave(ExternalResource resource) {
        ExternalResource merged = (ExternalResource)this.resourceDAO.save((Entity)resource);
        try {
            this.connectorManager.registerConnector(merged);
        }
        catch (NotFoundException e) {
            LOG.error("While registering connector for resource", (Throwable)e);
        }
        return merged;
    }

    @PreAuthorize(value="hasRole('RESOURCE_CREATE')")
    public ResourceTO create(ResourceTO resourceTO) {
        if (StringUtils.isBlank((CharSequence)resourceTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Resource key");
            throw sce;
        }
        ConnInstance connInstance = this.connInstanceDAO.authFind(resourceTO.getConnector());
        if (connInstance == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidExternalResource);
            sce.getElements().add("Connector " + resourceTO.getConnector());
            throw sce;
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_CREATE")), (String)connInstance.getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, connInstance.getAdminRealm().getFullPath(), null);
        if (this.resourceDAO.authFind(resourceTO.getKey()) != null) {
            throw new DuplicateException(resourceTO.getKey());
        }
        return this.binder.getResourceTO(this.doSave(this.binder.create(resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public ResourceTO update(ResourceTO resourceTO) {
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(resourceTO.getKey())).orElseThrow(() -> new NotFoundException("Resource '" + resourceTO.getKey() + "'"));
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        return this.binder.getResourceTO(this.doSave(this.binder.update(resource, resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void setLatestSyncToken(String key, String anyTypeKey) {
        Connector connector;
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(key)).orElseThrow(() -> new NotFoundException("Resource '" + key + "'"));
        try {
            connector = this.connectorManager.getConnector(resource);
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidConnInstance);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(ConnObjectUtils.toString((SyncToken)connector.getLatestSyncToken(new ObjectClass(resource.getOrgUnit().getObjectClass()))));
        } else {
            AnyType anyType = (AnyType)this.anyTypeDAO.findById(anyTypeKey).orElseThrow(() -> new NotFoundException("AnyType " + anyTypeKey));
            Provision provision = (Provision)resource.getProvisionByAnyType(anyType.getKey()).orElseThrow(() -> new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'"));
            provision.setSyncToken(ConnObjectUtils.toString((SyncToken)connector.getLatestSyncToken(new ObjectClass(provision.getObjectClass()))));
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.doSave(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void removeSyncToken(String key, String anyTypeKey) {
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(key)).orElseThrow(() -> new NotFoundException("Resource '" + key + "'"));
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(null);
        } else {
            AnyType anyType = (AnyType)this.anyTypeDAO.findById(anyTypeKey).orElseThrow(() -> new NotFoundException("AnyType " + anyTypeKey));
            Provision provision = (Provision)resource.getProvisionByAnyType(anyType.getKey()).orElseThrow(() -> new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'"));
            provision.setSyncToken(null);
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.doSave(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_DELETE')")
    public ResourceTO delete(String key) {
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(key)).orElseThrow(() -> new NotFoundException("Resource '" + key + "'"));
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_DELETE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.connectorManager.unregisterConnector(resource);
        ResourceTO deleted = this.binder.getResourceTO(resource);
        this.resourceDAO.deleteById(key);
        return deleted;
    }

    @PreAuthorize(value="hasRole('RESOURCE_READ')")
    @Transactional(readOnly=true)
    public ResourceTO read(String key) {
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(key)).orElseThrow(() -> new NotFoundException("Resource '" + key + "'"));
        return this.binder.getResourceTO(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST')")
    @Transactional(readOnly=true)
    public List<ResourceTO> list() {
        return this.resourceDAO.findAll().stream().map(arg_0 -> ((ResourceDataBinder)this.binder).getResourceTO(arg_0)).toList();
    }

    protected AbstractTransactionalLogic.ProvisioningInfo getProvisioningInfo(String anyTypeKey, String resourceKey) {
        AnyType anyType = (AnyType)this.anyTypeDAO.findById(anyTypeKey).orElseThrow(() -> new NotFoundException("AnyType " + anyTypeKey));
        ExternalResource resource = Optional.ofNullable(this.resourceDAO.authFind(resourceKey)).orElseThrow(() -> new NotFoundException("Resource '" + resourceKey + "'"));
        Provision provision = (Provision)resource.getProvisionByAnyType(anyType.getKey()).orElseThrow(() -> new NotFoundException("Provision for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'"));
        if (provision.getMapping() == null) {
            throw new NotFoundException("Mapping for " + String.valueOf(anyType) + " on Resource '" + resourceKey + "'");
        }
        return new AbstractTransactionalLogic.ProvisioningInfo(anyType, resource, provision);
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public String getConnObjectKeyValue(String key, String anyTypeKey, String anyKey) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, key);
        Any any = Optional.ofNullable(this.anyUtilsFactory.getInstance(info.anyType().getKind()).dao().authFind(anyKey)).orElseThrow(() -> new NotFoundException(String.valueOf(info.anyType()) + " " + anyKey));
        return (String)this.mappingManager.getConnObjectKeyValue(any, info.resource(), info.provision()).orElseThrow(() -> new NotFoundException("No ConnObjectKey value found for " + anyTypeKey + " " + anyKey + " on resource '" + key + "'"));
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public ConnObject readConnObjectByAnyKey(String key, String anyTypeKey, String anyKey) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, key);
        Any any = Optional.ofNullable(this.anyUtilsFactory.getInstance(info.anyType().getKind()).dao().authFind(anyKey)).orElseThrow(() -> new NotFoundException(String.valueOf(info.anyType()) + " " + anyKey));
        List connObjs = this.outboundMatcher.match(this.connectorManager.getConnector(info.resource()), any, info.resource(), info.provision(), Optional.empty());
        if (connObjs.isEmpty()) {
            throw new NotFoundException("Object " + String.valueOf(any) + " with class " + info.provision().getObjectClass() + " not found on resource " + info.resource().getKey());
        }
        if (connObjs.size() > 1) {
            LOG.warn("Expected single match, found {}", (Object)connObjs);
        }
        return ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL((ConnectorObject)connObjs.getFirst(), info.resource(), info.provision()), (Set)((ConnectorObject)connObjs.getFirst()).getAttributes());
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public ConnObject readConnObjectByConnObjectKeyValue(String key, String anyTypeKey, String connObjectKeyValue) {
        AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, key);
        Item connObjectKeyItem = (Item)MappingUtils.getConnObjectKeyItem((Provision)info.provision()).orElseThrow(() -> new NotFoundException("ConnObjectKey mapping for " + info.anyType().getKey() + " on resource '" + info.resource().getKey() + "'"));
        return this.outboundMatcher.matchByConnObjectKeyValue(this.connectorManager.getConnector(info.resource()), connObjectKeyItem, connObjectKeyValue, info.provision(), Optional.empty()).map(connectorObject -> ConnObjectUtils.getConnObjectTO((String)this.outboundMatcher.getFIQL(connectorObject, info.resource(), info.provision()), (Set)connectorObject.getAttributes())).orElseThrow(() -> new NotFoundException("Object " + connObjectKeyValue + " with class " + info.provision().getObjectClass() + " not found on resource " + info.resource().getKey()));
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST_CONNOBJECT')")
    @Transactional(readOnly=true)
    public Pair<SearchResult, List<ConnObject>> searchConnObjects(Filter filter, Set<String> moreAttrsToGet, String key, String anyTypeKey, final int size, String pagedResultsCookie, List<Sort.Order> sort) {
        OperationOptions options;
        ObjectClass objectClass;
        Provision provision;
        ExternalResource resource;
        if ("REALM".equals(anyTypeKey)) {
            resource = (ExternalResource)this.resourceDAO.findById(key).orElseThrow(() -> new NotFoundException("Resource " + key));
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provisioning for resource '" + key + "'");
            }
            provision = null;
            objectClass = new ObjectClass(resource.getOrgUnit().getObjectClass());
            options = MappingUtils.buildOperationOptions(resource.getOrgUnit().getItems().stream(), (String[])((String[])moreAttrsToGet.toArray(String[]::new)));
        } else {
            AbstractTransactionalLogic.ProvisioningInfo info = this.getProvisioningInfo(anyTypeKey, key);
            provision = info.provision();
            resource = info.resource();
            objectClass = new ObjectClass(provision.getObjectClass());
            options = MappingUtils.buildOperationOptions(provision.getMapping().getItems().stream(), (String[])((String[])moreAttrsToGet.toArray(String[]::new)));
        }
        final ArrayList connObjects = new ArrayList();
        SearchResult searchResult = this.connectorManager.getConnector(resource).search(objectClass, filter, new SearchResultsHandler(){
            private int count;

            public boolean handle(ConnectorObject connectorObject) {
                connObjects.add(ConnObjectUtils.getConnObjectTO(provision == null ? null : ResourceLogic.this.outboundMatcher.getFIQL(connectorObject, resource, provision), (Set)connectorObject.getAttributes()));
                ++this.count;
                return this.count < size;
            }

            public void handleResult(SearchResult sr) {
            }
        }, size, pagedResultsCookie, sort, options);
        return Pair.of((Object)searchResult, connObjects);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public void check(ResourceTO resourceTO) {
        ConnInstance connInstance = (ConnInstance)this.connInstanceDAO.findById(resourceTO.getConnector()).orElseThrow(() -> new NotFoundException("Connector " + resourceTO.getConnector()));
        this.connectorManager.createConnector(this.connectorManager.buildConnInstanceOverride(this.connInstanceDataBinder.getConnInstanceTO(connInstance), resourceTO.getConfOverride(), resourceTO.getCapabilitiesOverride())).test();
    }

    protected ResourceTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof ResourceTO)) continue;
                ResourceTO resourceTO = (ResourceTO)object;
                key = resourceTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getResourceTO((ExternalResource)this.resourceDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

