/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.util.Map;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.client5.http.cache.ResponseCacheControl;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectLocations;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HttpCacheContext
extends HttpClientContext {
    @Deprecated
    public static final String CACHE_RESPONSE_STATUS = "http.cache.response.status";
    static final String REQUEST_CACHE_CONTROL = "http.cache.request-control";
    static final String RESPONSE_CACHE_CONTROL = "http.cache.response-control";
    static final String CACHE_ENTRY = "http.cache.entry";
    private CacheResponseStatus responseStatus;
    private RequestCacheControl requestCacheControl;
    private ResponseCacheControl responseCacheControl;
    private HttpCacheEntry cacheEntry;

    @Deprecated
    public static HttpCacheContext adapt(HttpContext context) {
        if (context instanceof HttpCacheContext) {
            return (HttpCacheContext)context;
        }
        return new Delegate(HttpClientContext.castOrCreate((HttpContext)context));
    }

    public static HttpCacheContext cast(HttpContext context) {
        if (context == null) {
            return null;
        }
        if (context instanceof HttpCacheContext) {
            return (HttpCacheContext)context;
        }
        if (context instanceof HttpClientContext) {
            return new Delegate((HttpClientContext)context);
        }
        return new Delegate(HttpClientContext.cast((HttpContext)context));
    }

    public static HttpCacheContext castOrCreate(HttpContext context) {
        return context != null ? HttpCacheContext.cast(context) : HttpCacheContext.create();
    }

    public static HttpCacheContext create() {
        return new HttpCacheContext();
    }

    public HttpCacheContext(HttpContext context) {
        super(context);
    }

    public HttpCacheContext() {
    }

    public CacheResponseStatus getCacheResponseStatus() {
        return this.responseStatus;
    }

    @Internal
    public void setCacheResponseStatus(CacheResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
    }

    public RequestCacheControl getRequestCacheControl() {
        return this.requestCacheControl;
    }

    public final RequestCacheControl getRequestCacheControlOrDefault() {
        RequestCacheControl cacheControl = this.getRequestCacheControl();
        return cacheControl != null ? cacheControl : RequestCacheControl.DEFAULT;
    }

    @Internal
    public void setRequestCacheControl(RequestCacheControl requestCacheControl) {
        this.requestCacheControl = requestCacheControl;
    }

    public ResponseCacheControl getResponseCacheControl() {
        return this.responseCacheControl;
    }

    public final ResponseCacheControl getResponseCacheControlOrDefault() {
        ResponseCacheControl cacheControl = this.getResponseCacheControl();
        return cacheControl != null ? cacheControl : ResponseCacheControl.DEFAULT;
    }

    @Internal
    public void setResponseCacheControl(ResponseCacheControl responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public HttpCacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    @Internal
    public void setCacheEntry(HttpCacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    @Internal
    static class Delegate
    extends HttpCacheContext {
        private final HttpClientContext clientContext;

        Delegate(HttpClientContext clientContext) {
            super(null);
            this.clientContext = clientContext;
        }

        @Override
        public CacheResponseStatus getCacheResponseStatus() {
            return (CacheResponseStatus)((Object)this.clientContext.getAttribute(HttpCacheContext.CACHE_RESPONSE_STATUS, CacheResponseStatus.class));
        }

        @Override
        public void setCacheResponseStatus(CacheResponseStatus responseStatus) {
            this.clientContext.setAttribute(HttpCacheContext.CACHE_RESPONSE_STATUS, (Object)responseStatus);
        }

        @Override
        public RequestCacheControl getRequestCacheControl() {
            return (RequestCacheControl)this.clientContext.getAttribute(HttpCacheContext.REQUEST_CACHE_CONTROL, RequestCacheControl.class);
        }

        @Override
        public void setRequestCacheControl(RequestCacheControl requestCacheControl) {
            this.clientContext.setAttribute(HttpCacheContext.REQUEST_CACHE_CONTROL, (Object)requestCacheControl);
        }

        @Override
        public ResponseCacheControl getResponseCacheControl() {
            return (ResponseCacheControl)this.clientContext.getAttribute(HttpCacheContext.RESPONSE_CACHE_CONTROL, ResponseCacheControl.class);
        }

        @Override
        public void setResponseCacheControl(ResponseCacheControl responseCacheControl) {
            this.clientContext.setAttribute(HttpCacheContext.RESPONSE_CACHE_CONTROL, (Object)responseCacheControl);
        }

        @Override
        public HttpCacheEntry getCacheEntry() {
            return (HttpCacheEntry)this.clientContext.getAttribute(HttpCacheContext.CACHE_ENTRY, HttpCacheEntry.class);
        }

        @Override
        public void setCacheEntry(HttpCacheEntry cacheEntry) {
            this.clientContext.setAttribute(HttpCacheContext.CACHE_ENTRY, (Object)cacheEntry);
        }

        public RouteInfo getHttpRoute() {
            return this.clientContext.getHttpRoute();
        }

        @Internal
        public void setRoute(HttpRoute route) {
            this.clientContext.setRoute(route);
        }

        public RedirectLocations getRedirectLocations() {
            return this.clientContext.getRedirectLocations();
        }

        @Internal
        public void setRedirectLocations(RedirectLocations redirectLocations) {
            this.clientContext.setRedirectLocations(redirectLocations);
        }

        public CookieStore getCookieStore() {
            return this.clientContext.getCookieStore();
        }

        public void setCookieStore(CookieStore cookieStore) {
            this.clientContext.setCookieStore(cookieStore);
        }

        public CookieSpec getCookieSpec() {
            return this.clientContext.getCookieSpec();
        }

        @Internal
        public void setCookieSpec(CookieSpec cookieSpec) {
            this.clientContext.setCookieSpec(cookieSpec);
        }

        public CookieOrigin getCookieOrigin() {
            return this.clientContext.getCookieOrigin();
        }

        @Internal
        public void setCookieOrigin(CookieOrigin cookieOrigin) {
            this.clientContext.setCookieOrigin(cookieOrigin);
        }

        public Lookup<CookieSpecFactory> getCookieSpecRegistry() {
            return this.clientContext.getCookieSpecRegistry();
        }

        public void setCookieSpecRegistry(Lookup<CookieSpecFactory> lookup) {
            this.clientContext.setCookieSpecRegistry(lookup);
        }

        public Lookup<AuthSchemeFactory> getAuthSchemeRegistry() {
            return this.clientContext.getAuthSchemeRegistry();
        }

        public void setAuthSchemeRegistry(Lookup<AuthSchemeFactory> lookup) {
            this.clientContext.setAuthSchemeRegistry(lookup);
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.clientContext.getCredentialsProvider();
        }

        public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.clientContext.setCredentialsProvider(credentialsProvider);
        }

        public AuthCache getAuthCache() {
            return this.clientContext.getAuthCache();
        }

        public void setAuthCache(AuthCache authCache) {
            this.clientContext.setAuthCache(authCache);
        }

        public Map<HttpHost, AuthExchange> getAuthExchanges() {
            return this.clientContext.getAuthExchanges();
        }

        public AuthExchange getAuthExchange(HttpHost host) {
            return this.clientContext.getAuthExchange(host);
        }

        public void setAuthExchange(HttpHost host, AuthExchange authExchange) {
            this.clientContext.setAuthExchange(host, authExchange);
        }

        public void resetAuthExchange(HttpHost host, AuthScheme authScheme) {
            this.clientContext.resetAuthExchange(host, authScheme);
        }

        public Object getUserToken() {
            return this.clientContext.getUserToken();
        }

        public void setUserToken(Object userToken) {
            this.clientContext.setUserToken(userToken);
        }

        public RequestConfig getRequestConfig() {
            return this.clientContext.getRequestConfig();
        }

        public void setRequestConfig(RequestConfig requestConfig) {
            this.clientContext.setRequestConfig(requestConfig);
        }

        public String getExchangeId() {
            return this.clientContext.getExchangeId();
        }

        public void setExchangeId(String exchangeId) {
            this.clientContext.setExchangeId(exchangeId);
        }

        public HttpRequest getRequest() {
            return this.clientContext.getRequest();
        }

        public void setRequest(HttpRequest request) {
            this.clientContext.setRequest(request);
        }

        public HttpResponse getResponse() {
            return this.clientContext.getResponse();
        }

        public void setResponse(HttpResponse response) {
            this.clientContext.setResponse(response);
        }

        public EndpointDetails getEndpointDetails() {
            return this.clientContext.getEndpointDetails();
        }

        public void setEndpointDetails(EndpointDetails endpointDetails) {
            this.clientContext.setEndpointDetails(endpointDetails);
        }

        public SSLSession getSSLSession() {
            return this.clientContext.getSSLSession();
        }

        public void setSSLSession(SSLSession sslSession) {
            this.clientContext.setSSLSession(sslSession);
        }

        public ProtocolVersion getProtocolVersion() {
            return this.clientContext.getProtocolVersion();
        }

        public void setProtocolVersion(ProtocolVersion version) {
            this.clientContext.setProtocolVersion(version);
        }

        public Object getAttribute(String id) {
            return this.clientContext.getAttribute(id);
        }

        public Object setAttribute(String id, Object obj) {
            return this.clientContext.setAttribute(id, obj);
        }

        public Object removeAttribute(String id) {
            return this.clientContext.removeAttribute(id);
        }

        public <T> T getAttribute(String id, Class<T> clazz) {
            return (T)this.clientContext.getAttribute(id, clazz);
        }

        public String toString() {
            return this.clientContext.toString();
        }
    }
}

