/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.slf4j.Logger;

public abstract class BaseSAMLSimpleSignatureSecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseSAMLSimpleSignatureSecurityHandler.class);
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    @Nullable
    private SAMLPeerEntityContext peerContext;
    @Nullable
    private String samlProtocol;
    @Nullable
    private QName samlRole;
    @Nullable
    private SignatureValidationParameters signatureValidationParameters;
    @Nullable
    private SignatureTrustEngine trustEngine;

    @Nullable
    protected SignatureTrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    @NonnullAfterInit
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest cannot be null");
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.peerContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        QName qName = this.samlRole = this.peerContext != null ? this.peerContext.getRole() : null;
        if (this.samlRole == null) {
            throw new MessageHandlerException("SAMLPeerEntityContext was missing or unpopulated");
        }
        SAMLProtocolContext samlProtocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class);
        String string = this.samlProtocol = samlProtocolContext != null ? samlProtocolContext.getProtocol() : null;
        if (this.samlProtocol == null) {
            throw new MessageHandlerException("SAMLProtocolContext was missing or unpopulated");
        }
        SecurityParametersContext secParams = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
        this.signatureValidationParameters = secParams != null ? secParams.getSignatureValidationParameters() : null;
        SignatureTrustEngine signatureTrustEngine = this.trustEngine = this.signatureValidationParameters != null ? this.signatureValidationParameters.getSignatureTrustEngine() : null;
        if (this.trustEngine == null) {
            throw new MessageHandlerException("No SignatureTrustEngine was available from the MessageContext");
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("{} Evaluating simple signature rule of type: {}", (Object)this.getLogPrefix(), (Object)((Object)((Object)this)).getClass().getName());
        if (!this.ruleHandles(messageContext)) {
            this.log.debug("{} Handler can not handle this request, skipping", (Object)this.getLogPrefix());
            return;
        }
        byte[] signature = this.getSignature();
        if (signature == null || signature.length == 0) {
            this.log.debug("{} HTTP request was not signed via simple signature mechanism, skipping", (Object)this.getLogPrefix());
            return;
        }
        String sigAlg = this.getSignatureAlgorithm();
        if (Strings.isNullOrEmpty((String)sigAlg)) {
            this.log.warn("{} Signature algorithm could not be extracted from request, cannot validate simple signature", (Object)this.getLogPrefix());
            return;
        }
        assert (sigAlg != null);
        byte[] signedContent = this.getSignedContent();
        if (signedContent == null || signedContent.length == 0) {
            this.log.warn("{} Signed content could not be extracted from HTTP request, cannot validate", (Object)this.getLogPrefix());
            return;
        }
        this.doEvaluate(signature, signedContent, sigAlg, messageContext);
    }

    private void doEvaluate(@Nonnull @NotEmpty byte[] signature, @Nonnull @NotEmpty byte[] signedContent, @Nonnull @NotEmpty String algorithmURI, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        List<Credential> candidateCredentials = this.getRequestCredentials(messageContext);
        SAMLPeerEntityContext peerEntityContext = this.peerContext;
        assert (peerEntityContext != null);
        String contextEntityID = peerEntityContext.getEntityId();
        if (contextEntityID != null) {
            this.log.debug("{} Attempting to validate SAML protocol message simple signature using context entityID: {}", (Object)this.getLogPrefix(), (Object)contextEntityID);
            CriteriaSet criteriaSet = this.buildCriteriaSet(contextEntityID, messageContext);
            if (this.validateSignature(signature, signedContent, algorithmURI, criteriaSet, candidateCredentials)) {
                this.log.debug("{} Validation of request simple signature succeeded", (Object)this.getLogPrefix());
                if (!peerEntityContext.isAuthenticated()) {
                    this.log.debug("{} Authentication via request simple signature succeeded for context issuer entity ID {}", (Object)this.getLogPrefix(), (Object)contextEntityID);
                    peerEntityContext.setAuthenticated(true);
                }
                return;
            }
            this.log.warn("{} Validation of request simple signature failed for context issuer: {}", (Object)this.getLogPrefix(), (Object)contextEntityID);
            throw new MessageHandlerException("Validation of request simple signature failed for context issuer");
        }
        String derivedEntityID = this.deriveSignerEntityID(messageContext);
        if (derivedEntityID != null) {
            this.log.debug("{} Attempting to validate SAML protocol message simple signature using derived entityID: {}", (Object)this.getLogPrefix(), (Object)derivedEntityID);
            CriteriaSet criteriaSet = this.buildCriteriaSet(derivedEntityID, messageContext);
            if (this.validateSignature(signature, signedContent, algorithmURI, criteriaSet, candidateCredentials)) {
                this.log.debug("{} Validation of request simple signature succeeded", (Object)this.getLogPrefix());
                if (!peerEntityContext.isAuthenticated()) {
                    this.log.debug("{} Authentication via request simple signature succeeded for derived issuer {}", (Object)this.getLogPrefix(), (Object)derivedEntityID);
                    peerEntityContext.setEntityId(derivedEntityID);
                    peerEntityContext.setAuthenticated(true);
                }
                return;
            }
            this.log.warn("{} Validation of request simple signature failed for derived issuer: {}", (Object)this.getLogPrefix(), (Object)derivedEntityID);
            throw new MessageHandlerException("Validation of request simple signature failed for derived issuer");
        }
        this.log.warn("{} Neither context nor derived issuer available, cannot attempt SAML simple signature validation", (Object)this.getLogPrefix());
        throw new MessageHandlerException("No message issuer available, cannot attempt simple signature validation");
    }

    protected boolean validateSignature(@Nonnull @NotEmpty byte[] signature, @Nonnull @NotEmpty byte[] signedContent, @Nonnull @NotEmpty String algorithmURI, @Nonnull CriteriaSet criteriaSet, @Nonnull List<Credential> candidateCredentials) throws MessageHandlerException {
        SignatureTrustEngine engine = this.getTrustEngine();
        assert (engine != null);
        try {
            if (candidateCredentials == null || candidateCredentials.isEmpty()) {
                if (engine.validate(signature, signedContent, algorithmURI, criteriaSet, null)) {
                    this.log.debug("{} Simple signature validation (with no request-derived credentials) was successful", (Object)this.getLogPrefix());
                    return true;
                }
                this.log.warn("{} Simple signature validation (with no request-derived credentials) failed", (Object)this.getLogPrefix());
                return false;
            }
            for (Credential cred : candidateCredentials) {
                if (!engine.validate(signature, signedContent, algorithmURI, criteriaSet, cred)) continue;
                this.log.debug("{} Simple signature validation succeeded with a request-derived credential", (Object)this.getLogPrefix());
                return true;
            }
            this.log.warn("{} Signature validation using request-derived credentials failed", (Object)this.getLogPrefix());
            return false;
        }
        catch (SecurityException e) {
            this.log.warn("{} Error evaluating the request's simple signature using the trust engine: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error during trust engine evaluation of the simple signature", (Exception)((Object)e));
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<Credential> getRequestCredentials(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        return CollectionSupport.emptyList();
    }

    @Nullable
    protected byte[] getSignature() throws MessageHandlerException {
        String signature = this.getHttpServletRequest().getParameter("Signature");
        if (Strings.isNullOrEmpty((String)signature)) {
            return null;
        }
        assert (signature != null);
        try {
            return Base64Support.decode((String)signature);
        }
        catch (DecodingException e) {
            throw new MessageHandlerException("Signature could not be base64 decoded", (Exception)((Object)e));
        }
    }

    @Nullable
    protected String getSignatureAlgorithm() throws MessageHandlerException {
        return this.getHttpServletRequest().getParameter("SigAlg");
    }

    @Nullable
    protected String deriveSignerEntityID(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        return null;
    }

    @Nonnull
    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            assert (entityID != null);
            criteriaSet.add((Object)new EntityIdCriterion(entityID));
        }
        assert (this.samlRole != null);
        criteriaSet.add((Object)new EntityRoleCriterion(this.samlRole));
        assert (this.samlProtocol != null);
        criteriaSet.add((Object)new ProtocolCriterion(this.samlProtocol));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        if (this.signatureValidationParameters != null) {
            criteriaSet.add((Object)new SignatureValidationParametersCriterion(this.signatureValidationParameters));
        }
        return criteriaSet;
    }

    @Nullable
    protected abstract byte[] getSignedContent() throws MessageHandlerException;

    protected abstract boolean ruleHandles(@Nonnull MessageContext var1) throws MessageHandlerException;
}

