/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.LinkedList;
import org.apache.openjpa.persistence.query.Aggregate;
import org.apache.openjpa.persistence.query.AverageExpression;
import org.apache.openjpa.persistence.query.CountExpression;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.ExpressionImpl;
import org.apache.openjpa.persistence.query.IsEmptyExpression;
import org.apache.openjpa.persistence.query.MaxExpression;
import org.apache.openjpa.persistence.query.MinExpression;
import org.apache.openjpa.persistence.query.PathExpression;
import org.apache.openjpa.persistence.query.PathOperator;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.QueryDefinitionImpl;
import org.apache.openjpa.persistence.query.SizeExpression;
import org.apache.openjpa.persistence.query.SumExpression;
import org.apache.openjpa.persistence.query.TypeExpression;

abstract class AbstractPath
extends ExpressionImpl
implements PathExpression {
    private static final long serialVersionUID = 1L;
    protected final AbstractPath _parent;
    protected final Object _part2;
    protected final PathOperator _operator;
    protected final QueryDefinitionImpl _owner;

    protected AbstractPath(QueryDefinitionImpl owner, AbstractPath parent, PathOperator op, Object part2) {
        this._owner = owner;
        this._parent = parent;
        this._part2 = part2;
        this._operator = op;
    }

    final QueryDefinitionImpl getOwner() {
        return this._owner;
    }

    public AbstractPath getParent() {
        return this._parent;
    }

    public PathOperator getOperator() {
        return this._operator;
    }

    public Object getLastSegment() {
        return this._part2;
    }

    @Override
    public Aggregate avg() {
        return new AverageExpression(this);
    }

    @Override
    public Aggregate count() {
        return new CountExpression(this);
    }

    @Override
    public Predicate isEmpty() {
        return new IsEmptyExpression(this);
    }

    @Override
    public Aggregate max() {
        return new MaxExpression(this);
    }

    @Override
    public Aggregate min() {
        return new MinExpression(this);
    }

    @Override
    public Expression size() {
        return new SizeExpression(this);
    }

    @Override
    public Aggregate sum() {
        return new SumExpression(this);
    }

    @Override
    public Expression type() {
        return new TypeExpression(this);
    }

    LinkedList<AbstractPath> split() {
        return this._split(this, new LinkedList<AbstractPath>());
    }

    private LinkedList<AbstractPath> _split(AbstractPath path, LinkedList<AbstractPath> list) {
        if (path == null) {
            return list;
        }
        this._split(path.getParent(), list);
        list.add(path);
        return list;
    }
}

