/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.collections;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.ops4j.util.collections.PropertyResolver;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties readProps(URL propsUrl, Properties mappings) throws IOException {
        InputStream stream = propsUrl.openStream();
        return PropertiesUtils.readProperties(stream, mappings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(InputStream stream, Properties mappings, boolean closeStream) throws IOException {
        try {
            Properties p = new Properties();
            p.load(stream);
            mappings.putAll((Map<?, ?>)p);
            boolean doAgain = true;
            while (doAgain) {
                doAgain = false;
                for (Map.Entry entry : p.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value.indexOf("${") < 0) continue;
                    value = PropertiesUtils.resolveProperty(mappings, value);
                    entry.setValue(value);
                    doAgain = true;
                }
            }
            Properties properties = p;
            return properties;
        }
        finally {
            if (closeStream) {
                stream.close();
            }
        }
    }

    public static String resolveProperty(Properties props, String value) {
        return PropertyResolver.resolve(props, value);
    }

    public static String getProperty(Properties props, String key, String def) {
        String value = props.getProperty(key, def);
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return value;
        }
        value = PropertyResolver.resolve(props, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readListFile(URL listFile) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (InputStream stream = listFile.openStream();){
            InputStreamReader isr = new InputStreamReader(stream, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            String[] items = new String[list.size()];
            list.toArray(items);
            String[] stringArray = items;
            return stringArray;
        }
    }
}

