/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MergesStats
implements JsonpSerializable {
    private final long current;
    private final long currentDocs;
    @Nullable
    private final String currentSize;
    private final long currentSizeInBytes;
    private final long total;
    @Nullable
    private final String totalAutoThrottle;
    private final long totalAutoThrottleInBytes;
    private final long totalDocs;
    @Nullable
    private final String totalSize;
    private final long totalSizeInBytes;
    @Nullable
    private final Time totalStoppedTime;
    private final long totalStoppedTimeInMillis;
    @Nullable
    private final Time totalThrottledTime;
    private final long totalThrottledTimeInMillis;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<MergesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MergesStats::setupMergesStatsDeserializer);

    private MergesStats(Builder builder) {
        this.current = ApiTypeHelper.requireNonNull(builder.current, (Object)this, "current", 0L);
        this.currentDocs = ApiTypeHelper.requireNonNull(builder.currentDocs, (Object)this, "currentDocs", 0L);
        this.currentSize = builder.currentSize;
        this.currentSizeInBytes = ApiTypeHelper.requireNonNull(builder.currentSizeInBytes, (Object)this, "currentSizeInBytes", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
        this.totalAutoThrottle = builder.totalAutoThrottle;
        this.totalAutoThrottleInBytes = ApiTypeHelper.requireNonNull(builder.totalAutoThrottleInBytes, (Object)this, "totalAutoThrottleInBytes", 0L);
        this.totalDocs = ApiTypeHelper.requireNonNull(builder.totalDocs, (Object)this, "totalDocs", 0L);
        this.totalSize = builder.totalSize;
        this.totalSizeInBytes = ApiTypeHelper.requireNonNull(builder.totalSizeInBytes, (Object)this, "totalSizeInBytes", 0L);
        this.totalStoppedTime = builder.totalStoppedTime;
        this.totalStoppedTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalStoppedTimeInMillis, (Object)this, "totalStoppedTimeInMillis", 0L);
        this.totalThrottledTime = builder.totalThrottledTime;
        this.totalThrottledTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalThrottledTimeInMillis, (Object)this, "totalThrottledTimeInMillis", 0L);
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, (Object)this, "totalTimeInMillis", 0L);
    }

    public static MergesStats of(Function<Builder, ObjectBuilder<MergesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long current() {
        return this.current;
    }

    public final long currentDocs() {
        return this.currentDocs;
    }

    @Nullable
    public final String currentSize() {
        return this.currentSize;
    }

    public final long currentSizeInBytes() {
        return this.currentSizeInBytes;
    }

    public final long total() {
        return this.total;
    }

    @Nullable
    public final String totalAutoThrottle() {
        return this.totalAutoThrottle;
    }

    public final long totalAutoThrottleInBytes() {
        return this.totalAutoThrottleInBytes;
    }

    public final long totalDocs() {
        return this.totalDocs;
    }

    @Nullable
    public final String totalSize() {
        return this.totalSize;
    }

    public final long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public final Time totalStoppedTime() {
        return this.totalStoppedTime;
    }

    public final long totalStoppedTimeInMillis() {
        return this.totalStoppedTimeInMillis;
    }

    @Nullable
    public final Time totalThrottledTime() {
        return this.totalThrottledTime;
    }

    public final long totalThrottledTimeInMillis() {
        return this.totalThrottledTimeInMillis;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("current_docs");
        generator.write(this.currentDocs);
        if (this.currentSize != null) {
            generator.writeKey("current_size");
            generator.write(this.currentSize);
        }
        generator.writeKey("current_size_in_bytes");
        generator.write(this.currentSizeInBytes);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalAutoThrottle != null) {
            generator.writeKey("total_auto_throttle");
            generator.write(this.totalAutoThrottle);
        }
        generator.writeKey("total_auto_throttle_in_bytes");
        generator.write(this.totalAutoThrottleInBytes);
        generator.writeKey("total_docs");
        generator.write(this.totalDocs);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (this.totalStoppedTime != null) {
            generator.writeKey("total_stopped_time");
            this.totalStoppedTime.serialize(generator, mapper);
        }
        generator.writeKey("total_stopped_time_in_millis");
        generator.write(this.totalStoppedTimeInMillis);
        if (this.totalThrottledTime != null) {
            generator.writeKey("total_throttled_time");
            this.totalThrottledTime.serialize(generator, mapper);
        }
        generator.writeKey("total_throttled_time_in_millis");
        generator.write(this.totalThrottledTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupMergesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::currentDocs, JsonpDeserializer.longDeserializer(), "current_docs");
        op.add(Builder::currentSize, JsonpDeserializer.stringDeserializer(), "current_size");
        op.add(Builder::currentSizeInBytes, JsonpDeserializer.longDeserializer(), "current_size_in_bytes");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalAutoThrottle, JsonpDeserializer.stringDeserializer(), "total_auto_throttle");
        op.add(Builder::totalAutoThrottleInBytes, JsonpDeserializer.longDeserializer(), "total_auto_throttle_in_bytes");
        op.add(Builder::totalDocs, JsonpDeserializer.longDeserializer(), "total_docs");
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::totalStoppedTime, Time._DESERIALIZER, "total_stopped_time");
        op.add(Builder::totalStoppedTimeInMillis, JsonpDeserializer.longDeserializer(), "total_stopped_time_in_millis");
        op.add(Builder::totalThrottledTime, Time._DESERIALIZER, "total_throttled_time");
        op.add(Builder::totalThrottledTimeInMillis, JsonpDeserializer.longDeserializer(), "total_throttled_time_in_millis");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MergesStats> {
        private Long current;
        private Long currentDocs;
        @Nullable
        private String currentSize;
        private Long currentSizeInBytes;
        private Long total;
        @Nullable
        private String totalAutoThrottle;
        private Long totalAutoThrottleInBytes;
        private Long totalDocs;
        @Nullable
        private String totalSize;
        private Long totalSizeInBytes;
        @Nullable
        private Time totalStoppedTime;
        private Long totalStoppedTimeInMillis;
        @Nullable
        private Time totalThrottledTime;
        private Long totalThrottledTimeInMillis;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder currentDocs(long value) {
            this.currentDocs = value;
            return this;
        }

        public final Builder currentSize(@Nullable String value) {
            this.currentSize = value;
            return this;
        }

        public final Builder currentSizeInBytes(long value) {
            this.currentSizeInBytes = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalAutoThrottle(@Nullable String value) {
            this.totalAutoThrottle = value;
            return this;
        }

        public final Builder totalAutoThrottleInBytes(long value) {
            this.totalAutoThrottleInBytes = value;
            return this;
        }

        public final Builder totalDocs(long value) {
            this.totalDocs = value;
            return this;
        }

        public final Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        public final Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public final Builder totalStoppedTime(@Nullable Time value) {
            this.totalStoppedTime = value;
            return this;
        }

        public final Builder totalStoppedTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalStoppedTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalStoppedTimeInMillis(long value) {
            this.totalStoppedTimeInMillis = value;
            return this;
        }

        public final Builder totalThrottledTime(@Nullable Time value) {
            this.totalThrottledTime = value;
            return this;
        }

        public final Builder totalThrottledTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalThrottledTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalThrottledTimeInMillis(long value) {
            this.totalThrottledTimeInMillis = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MergesStats build() {
            this._checkSingleUse();
            return new MergesStats(this);
        }
    }
}

