/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import org.apache.karaf.jpm.Process;
import org.apache.karaf.jpm.impl.ProcessBuilderFactoryImpl;
import org.apache.karaf.main.ConfigProperties;

public class Stop {
    public static void main(String[] args) throws Exception {
        ConfigProperties config = new ConfigProperties();
        if (config.shutdownPort == 0 && config.portFile != null) {
            try {
                config.shutdownPort = Stop.getPortFromShutdownPortFile(config.portFile);
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(config.portFile + " shutdown port file doesn't exist. The container is not running.");
                System.exit(3);
            }
            catch (IOException ioe) {
                System.err.println("Can't read " + config.portFile + " shutdown port file: " + ioe.getMessage());
                System.exit(4);
            }
        }
        if (config.shutdownPort > 0) {
            try (Socket s = new Socket(config.shutdownHost, config.shutdownPort);){
                s.getOutputStream().write(config.shutdownCommand.getBytes());
                s.getOutputStream().write(10);
                s.getOutputStream().flush();
            }
            catch (ConnectException connectException) {
                System.err.println("Can't connect to the container. The container is not running.");
                System.exit(1);
            }
            System.exit(0);
        } else {
            int pid = Stop.getPidFromPidFile(config.pidFile);
            Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(pid);
            if (process.isRunning()) {
                process.destroy();
                System.exit(0);
            } else {
                System.out.println("Not Running ...");
                System.exit(1);
            }
        }
    }

    private static int getPortFromShutdownPortFile(String portFile) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
        String portStr = r.readLine();
        int port = Integer.parseInt(portStr);
        r.close();
        return port;
    }

    private static int getPidFromPidFile(String pidFile) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(pidFile)));
        String pidString = r.readLine();
        int pid = Integer.parseInt(pidString);
        r.close();
        return pid;
    }
}

