# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from ..._utils import PropertyInfo
from ..._models import BaseModel

__all__ = [
    "ResponseApplyPatchToolCall",
    "Operation",
    "OperationCreateFile",
    "OperationDeleteFile",
    "OperationUpdateFile",
]


class OperationCreateFile(BaseModel):
    """Instruction describing how to create a file via the apply_patch tool."""

    diff: str
    """Diff to apply."""

    path: str
    """Path of the file to create."""

    type: Literal["create_file"]
    """Create a new file with the provided diff."""


class OperationDeleteFile(BaseModel):
    """Instruction describing how to delete a file via the apply_patch tool."""

    path: str
    """Path of the file to delete."""

    type: Literal["delete_file"]
    """Delete the specified file."""


class OperationUpdateFile(BaseModel):
    """Instruction describing how to update a file via the apply_patch tool."""

    diff: str
    """Diff to apply."""

    path: str
    """Path of the file to update."""

    type: Literal["update_file"]
    """Update an existing file with the provided diff."""


Operation: TypeAlias = Annotated[
    Union[OperationCreateFile, OperationDeleteFile, OperationUpdateFile], PropertyInfo(discriminator="type")
]


class ResponseApplyPatchToolCall(BaseModel):
    """A tool call that applies file diffs by creating, deleting, or updating files."""

    id: str
    """The unique ID of the apply patch tool call.

    Populated when this item is returned via API.
    """

    call_id: str
    """The unique ID of the apply patch tool call generated by the model."""

    operation: Operation
    """
    One of the create_file, delete_file, or update_file operations applied via
    apply_patch.
    """

    status: Literal["in_progress", "completed"]
    """The status of the apply patch tool call. One of `in_progress` or `completed`."""

    type: Literal["apply_patch_call"]
    """The type of the item. Always `apply_patch_call`."""

    created_by: Optional[str] = None
    """The ID of the entity that created this tool call."""
