/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.regex.Regex;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldMapper;
import org.opensearch.index.mapper.DerivedFieldResolver;
import org.opensearch.index.mapper.DerivedFieldType;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FieldTypeInference;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ObjectDerivedFieldType;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.Script;

public class DefaultDerivedFieldResolver
implements DerivedFieldResolver {
    private final QueryShardContext queryShardContext;
    private final Map<String, DerivedFieldType> derivedFieldTypeMap = new ConcurrentHashMap<String, DerivedFieldType>();
    private final FieldTypeInference typeInference;
    private static final Logger logger = LogManager.getLogger(DefaultDerivedFieldResolver.class);

    DefaultDerivedFieldResolver(QueryShardContext queryShardContext, Map<String, Object> derivedFieldsObject, List<DerivedField> derivedFields) {
        this(queryShardContext, derivedFieldsObject, derivedFields, new FieldTypeInference(queryShardContext.index().getName(), queryShardContext.getMapperService(), queryShardContext.getIndexReader()));
    }

    DefaultDerivedFieldResolver(QueryShardContext queryShardContext, Map<String, Object> derivedFieldsObject, List<DerivedField> derivedFields, FieldTypeInference typeInference) {
        this.queryShardContext = queryShardContext;
        this.initDerivedFieldTypes(derivedFieldsObject, derivedFields);
        this.typeInference = typeInference;
    }

    @Override
    public Set<String> resolvePattern(String pattern) {
        HashSet<String> derivedFields = new HashSet<String>();
        if (this.queryShardContext != null && this.queryShardContext.getMapperService() != null) {
            for (MappedFieldType fieldType : this.queryShardContext.getMapperService().fieldTypes()) {
                if (fieldType == null || !(fieldType.unwrap() instanceof DerivedFieldType) || !Regex.simpleMatch(pattern, fieldType.name())) continue;
                derivedFields.add(fieldType.name());
            }
        }
        for (String fieldName : this.derivedFieldTypeMap.keySet()) {
            if (!Regex.simpleMatch(pattern, fieldName)) continue;
            derivedFields.add(fieldName);
        }
        return derivedFields;
    }

    @Override
    public DerivedFieldType resolve(String fieldName) {
        return Optional.ofNullable(this.resolveUsingSearchDefinitions(fieldName)).orElseGet(() -> this.resolveUsingMappings(fieldName));
    }

    private DerivedFieldType resolveUsingSearchDefinitions(String fieldName) {
        return Optional.ofNullable(this.derivedFieldTypeMap.get(fieldName)).orElseGet(() -> Optional.ofNullable((DerivedFieldType)this.getParentDerivedField(fieldName)).map(parentDerivedField -> this.derivedFieldTypeMap.computeIfAbsent(fieldName, f -> this.resolveNestedField((String)f, (DerivedFieldType)parentDerivedField))).orElse(null));
    }

    private DerivedFieldType resolveNestedField(String fieldName, DerivedFieldType parentDerivedField) {
        Objects.requireNonNull(parentDerivedField);
        try {
            Mapper inferredFieldMapper;
            Script script = parentDerivedField.derivedField.getScript();
            String nestedType = DefaultDerivedFieldResolver.explicitTypeFromParent(parentDerivedField.derivedField, fieldName.substring(fieldName.indexOf(".") + 1));
            if (nestedType == null && (inferredFieldMapper = this.typeInference.infer(this.getValueFetcher(fieldName, script, parentDerivedField.derivedField.getIgnoreMalformed()))) != null) {
                nestedType = inferredFieldMapper.typeName();
            }
            if (nestedType != null) {
                DerivedField derivedField = new DerivedField(fieldName, nestedType, script);
                if (parentDerivedField.derivedField.getProperties() != null) {
                    derivedField.setProperties(parentDerivedField.derivedField.getProperties());
                }
                if (parentDerivedField.derivedField.getPrefilterField() != null) {
                    derivedField.setPrefilterField(parentDerivedField.derivedField.getPrefilterField());
                }
                if (parentDerivedField.derivedField.getFormat() != null) {
                    derivedField.setFormat(parentDerivedField.derivedField.getFormat());
                }
                if (parentDerivedField.derivedField.getIgnoreMalformed()) {
                    derivedField.setIgnoreMalformed(parentDerivedField.derivedField.getIgnoreMalformed());
                }
                return this.getDerivedFieldType(derivedField);
            }
            logger.warn("Field type cannot be inferred. Ensure the field {} is not rare across entire index or provide explicit mapping using [properties] under parent object [{}] ", (Object)fieldName, (Object)parentDerivedField.derivedField.getName());
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
        }
        return null;
    }

    private MappedFieldType getParentDerivedField(String fieldName) {
        if (fieldName.contains(".")) {
            return this.resolve(fieldName.split("\\.")[0]);
        }
        return null;
    }

    private static String explicitTypeFromParent(DerivedField parentDerivedField, String subField) {
        if (parentDerivedField == null) {
            return null;
        }
        return parentDerivedField.getNestedFieldType(subField);
    }

    ValueFetcher getValueFetcher(String fieldName, Script script, boolean ignoreMalformed) {
        String subFieldName = fieldName.substring(fieldName.indexOf(".") + 1);
        return new ObjectDerivedFieldType.ObjectDerivedFieldValueFetcher(subFieldName, DerivedFieldType.getDerivedFieldLeafFactory(script, this.queryShardContext, this.queryShardContext.lookup()), o -> o, ignoreMalformed);
    }

    private void initDerivedFieldTypes(Map<String, Object> derivedFieldsObject, List<DerivedField> derivedFields) {
        if (derivedFieldsObject != null && !derivedFieldsObject.isEmpty()) {
            HashMap<String, Object> derivedFieldObject = new HashMap<String, Object>();
            derivedFieldObject.put("derived", derivedFieldsObject);
            this.derivedFieldTypeMap.putAll(this.getAllDerivedFieldTypeFromObject(derivedFieldObject));
        }
        if (derivedFields != null) {
            for (DerivedField derivedField : derivedFields) {
                this.derivedFieldTypeMap.put(derivedField.getName(), this.getDerivedFieldType(derivedField));
            }
        }
    }

    private Map<String, DerivedFieldType> getAllDerivedFieldTypeFromObject(Map<String, Object> derivedFieldObject) {
        HashMap<String, DerivedFieldType> derivedFieldTypes = new HashMap<String, DerivedFieldType>();
        DocumentMapper documentMapper = this.queryShardContext.getMapperService().documentMapperParser().parse("derived", (Map)DefaultDerivedFieldResolver.deepCopy(derivedFieldObject));
        if (documentMapper != null && documentMapper.mappers() != null) {
            for (Mapper mapper : documentMapper.mappers()) {
                if (!(mapper instanceof DerivedFieldMapper)) continue;
                DerivedFieldMapper derivedFieldMapper = (DerivedFieldMapper)mapper;
                DerivedFieldType derivedFieldType = derivedFieldMapper.fieldType();
                derivedFieldTypes.put(derivedFieldType.name(), derivedFieldType);
            }
        }
        return derivedFieldTypes;
    }

    private DerivedFieldType getDerivedFieldType(DerivedField derivedField) {
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.queryShardContext.getMapperService().getIndexSettings().getSettings(), new ContentPath(1));
        DerivedFieldMapper.Builder builder = new DerivedFieldMapper.Builder(derivedField, this.queryShardContext.getMapperService().getIndexAnalyzers(), null, (boolean)FieldMapper.IGNORE_MALFORMED_SETTING.getDefault(this.queryShardContext.getIndexSettings().getSettings()));
        return builder.build(builderContext).fieldType();
    }

    private DerivedFieldType resolveUsingMappings(String name) {
        MappedFieldType mappedFieldType;
        if (this.queryShardContext != null && this.queryShardContext.getMapperService() != null && (mappedFieldType = this.queryShardContext.getMapperService().fieldType(name)) != null && mappedFieldType.unwrap() instanceof DerivedFieldType) {
            return (DerivedFieldType)mappedFieldType;
        }
        return null;
    }

    private static Object deepCopy(Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            HashMap copy = new HashMap(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), DefaultDerivedFieldResolver.deepCopy(entry.getValue()));
            }
            return copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(DefaultDerivedFieldResolver.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        return value;
    }
}

