/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.ranking;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.WindowFunctionExpression;
import org.opensearch.sql.expression.window.frame.CurrentRowWindowFrame;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;

public abstract class RankingWindowFunction
extends FunctionExpression
implements WindowFunctionExpression {
    protected int rank;

    public RankingWindowFunction(FunctionName functionName) {
        super(functionName, Collections.emptyList());
    }

    @Override
    public ExprType type() {
        return ExprCoreType.INTEGER;
    }

    @Override
    public WindowFrame createWindowFrame(WindowDefinition definition) {
        return new CurrentRowWindowFrame(definition);
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        return new ExprIntegerValue(this.rank((CurrentRowWindowFrame)valueEnv));
    }

    protected abstract int rank(CurrentRowWindowFrame var1);

    protected boolean isSortFieldValueDifferent(CurrentRowWindowFrame frame) {
        if (this.isSortItemsNotDefined(frame)) {
            return false;
        }
        List<Expression> sortItems = frame.getWindowDefinition().getSortList().stream().map(Pair::getRight).collect(Collectors.toList());
        List<ExprValue> previous = this.resolve(frame, sortItems, frame.previous());
        List<ExprValue> current = this.resolve(frame, sortItems, frame.current());
        return !current.equals(previous);
    }

    private boolean isSortItemsNotDefined(CurrentRowWindowFrame frame) {
        return frame.getWindowDefinition().getSortList().isEmpty();
    }

    private List<ExprValue> resolve(WindowFrame frame, List<Expression> expressions, ExprValue row) {
        BindingTuple valueEnv = row.bindingTuples();
        return expressions.stream().map(expr -> expr.valueOf(valueEnv)).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getFunctionName()) + "()";
    }
}

