"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
class SVG extends react_1.default.PureComponent {
    componentDidMount() {
        if (this.el) {
            this.el.insertAdjacentHTML("beforeend", this.props.data);
        }
    }
    componentDidUpdate() {
        if (!this.el) {
            return;
        }
        // clear out all DOM element children
        while (this.el.firstChild) {
            this.el.removeChild(this.el.firstChild);
        }
        this.el.insertAdjacentHTML("beforeend", this.props.data);
    }
    render() {
        return (react_1.default.createElement("div", { ref: el => {
                this.el = el;
            } }));
    }
}
exports.SVG = SVG;
SVG.defaultProps = {
    data: "",
    mediaType: "image/svg+xml"
};
exports.default = SVG;
