/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class SourceRule
implements Rule {
    public static final String ERROR_CODE = "SOURCE_VIOLATION";
    protected boolean reportAllFailures;

    public SourceRule() {
        this(true);
    }

    public SourceRule(boolean reportAll) {
        this.reportAllFailures = reportAll;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        List<PasswordData.SourceReference> references = passwordData.getPasswordReferences(PasswordData.SourceReference.class);
        if (references.isEmpty()) {
            return result;
        }
        String cleartext = passwordData.getPassword();
        if (this.reportAllFailures) {
            references.stream().filter(reference -> this.matches(cleartext, (PasswordData.Reference)reference)).forEach(reference -> result.addError(ERROR_CODE, this.createRuleResultDetailParameters(reference.getLabel())));
        } else {
            references.stream().filter(reference -> this.matches(cleartext, (PasswordData.Reference)reference)).findFirst().ifPresent(reference -> result.addError(ERROR_CODE, this.createRuleResultDetailParameters(reference.getLabel())));
        }
        return result;
    }

    protected boolean matches(String password, PasswordData.Reference reference) {
        return password.equals(reference.getPassword());
    }

    protected Map<String, Object> createRuleResultDetailParameters(String source) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("source", source);
        return m;
    }
}

