﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/MonitorSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {
class ListMonitorsResult {
 public:
  AWS_DEADLINE_API ListMonitorsResult() = default;
  AWS_DEADLINE_API ListMonitorsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEADLINE_API ListMonitorsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If Deadline Cloud returns <code>nextToken</code>, then there are more results
   * available. The value of <code>nextToken</code> is a unique pagination token for
   * each page. To retrieve the next page, call the operation again using the
   * returned token. Keep all other arguments unchanged. If no results remain, then
   * <code>nextToken</code> is set to <code>null</code>. Each pagination token
   * expires after 24 hours. If you provide a token that isn't valid, then you
   * receive an HTTP 400 <code>ValidationException</code> error.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListMonitorsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>MonitorSummary</code> objects that describe your monitors in
   * the Deadline Cloud.</p>
   */
  inline const Aws::Vector<MonitorSummary>& GetMonitors() const { return m_monitors; }
  template <typename MonitorsT = Aws::Vector<MonitorSummary>>
  void SetMonitors(MonitorsT&& value) {
    m_monitorsHasBeenSet = true;
    m_monitors = std::forward<MonitorsT>(value);
  }
  template <typename MonitorsT = Aws::Vector<MonitorSummary>>
  ListMonitorsResult& WithMonitors(MonitorsT&& value) {
    SetMonitors(std::forward<MonitorsT>(value));
    return *this;
  }
  template <typename MonitorsT = MonitorSummary>
  ListMonitorsResult& AddMonitors(MonitorsT&& value) {
    m_monitorsHasBeenSet = true;
    m_monitors.emplace_back(std::forward<MonitorsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListMonitorsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<MonitorSummary> m_monitors;
  bool m_monitorsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
