/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.KeyValue;
import com.adobe.epubcheck.util.XmlReportAbstract;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class XmpReportImpl
extends XmlReportAbstract {
    public XmpReportImpl(PrintWriter out, String ePubName, String versionEpubCheck) {
        super(out, ePubName, versionEpubCheck);
    }

    @Override
    public int generateReport() {
        if (this.out == null) {
            return 1;
        }
        int returnCode = 1;
        this.generationDate = XmpReportImpl.fromTime(System.currentTimeMillis());
        try {
            this.addPrefixNamespace("x", "adobe:ns:meta/");
            this.addPrefixNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.addPrefixNamespace("dc", "http://purl.org/dc/elements/1.1/");
            this.addPrefixNamespace("xmp", "http://ns.adobe.com/xap/1.0/");
            this.addPrefixNamespace("xmpTPg", "http://ns.adobe.com/xap/1.0/t/pg/");
            this.addPrefixNamespace("stFnt", "http://ns.adobe.com/xap/1.0/sType/Font#");
            this.addPrefixNamespace("extended-properties", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/");
            this.addPrefixNamespace("premis", "http://www.loc.gov/premis/rdf/v1#");
            this.startElement("x:xmpmeta", KeyValue.with("xmlns:x", "adobe:ns:meta/"), KeyValue.with("x:xmptk", "Adobe XMP Core 5.1.0-jc003"));
            this.startElement("rdf:RDF", KeyValue.with("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
            ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
            attrs.add(KeyValue.with("rdf:about", ""));
            attrs.add(KeyValue.with("xmlns:dc", "http://purl.org/dc/elements/1.1/"));
            attrs.add(KeyValue.with("xmlns:xmp", "http://ns.adobe.com/xap/1.0/"));
            attrs.add(KeyValue.with("xmlns:xmpTPg", "http://ns.adobe.com/xap/1.0/t/pg/"));
            attrs.add(KeyValue.with("xmlns:stFnt", "http://ns.adobe.com/xap/1.0/sType/Font#"));
            attrs.add(KeyValue.with("xmlns:extended-properties", "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties/"));
            attrs.add(KeyValue.with("xmlns:premis", "http://www.loc.gov/premis/rdf/v1#"));
            if (this.formatName == null) {
                attrs.add(KeyValue.with("dc:format", "application/octet-stream"));
            } else if (this.formatVersion == null) {
                attrs.add(KeyValue.with("dc:format", this.formatName));
            } else {
                attrs.add(KeyValue.with("dc:format", this.formatName + ";version=" + this.formatVersion));
            }
            if (this.creationDate != null) {
                attrs.add(KeyValue.with("xmp:CreateDate", this.creationDate));
            }
            if (this.charsCount != 0L) {
                attrs.add(KeyValue.with("extended-properties:Characters", Long.toString(this.charsCount)));
            }
            if (this.pagesCount != 0L) {
                attrs.add(KeyValue.with("xmpTPg:NPages", Long.toString(this.pagesCount)));
            }
            if (this.publisher != null) {
                attrs.add(KeyValue.with("dc:publisher", this.publisher));
            }
            attrs.add(KeyValue.with("dc:identifier", this.identifier));
            if (this.language != null) {
                attrs.add(KeyValue.with("dc:language", this.language));
            }
            this.startElement("rdf:Description", attrs);
            if (!this.creators.isEmpty()) {
                this.startElement("dc:creator");
                this.startElement("rdf:Seq");
                for (Object creator : this.creators) {
                    this.generateElement("rdf:li", (String)creator);
                }
                this.endElement("rdf:Seq");
                this.endElement("dc:creator");
            }
            if (!this.titles.isEmpty()) {
                this.startElement("dc:title");
                this.startElement("rdf:Alt");
                boolean first = true;
                for (String title : this.titles) {
                    if (first) {
                        this.generateElement("rdf:li", title.trim(), KeyValue.with("xml:lang", "x-default"));
                        first = false;
                        continue;
                    }
                    this.generateElement("rdf:li", title);
                }
                this.endElement("rdf:Alt");
                this.endElement("dc:title");
            }
            if (!this.subjects.isEmpty()) {
                this.startElement("dc:subject");
                this.startElement("rdf:Bag");
                for (String subject : this.subjects) {
                    this.generateElement("rdf:li", subject);
                }
                this.endElement("rdf:Bag");
                this.endElement("dc:subject");
            }
            if (!this.embeddedFonts.isEmpty() || !this.refFonts.isEmpty()) {
                this.startElement("xmpTPg:Fonts");
                this.startElement("rdf:Bag");
                for (String font : this.embeddedFonts) {
                    this.generateFont(font, true);
                }
                for (String font : this.refFonts) {
                    this.generateFont(font, false);
                }
                this.endElement("rdf:Bag");
                this.endElement("xmpTPg:Fonts");
            }
            this.startElement("premis:hasEvent", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement("premis:hasEventDateTime", this.generationDate, KeyValue.with("rdf:datatype", "http://www.w3.org/2001/XMLSchema#dateTime"));
            this.generateElement("premis:hasEventType", null, KeyValue.with("rdf:resource", "http://id.loc.gov/vocabulary/preservation/eventType/val"));
            if (this.fatalErrors.isEmpty() && this.errors.isEmpty()) {
                this.generateElement("premis:hasEventDetail", "Well-formed");
            } else {
                this.generateElement("premis:hasEventDetail", "Not well-formed");
            }
            if (this.fatalErrors.size() + this.errors.size() + this.warns.size() + this.hints.size() != 0) {
                this.startElement("premis:hasEventOutcomeInformation");
                this.startElement("rdf:Seq");
                this.generateEventOutcome(this.fatalErrors, "FATAL");
                this.generateEventOutcome(this.errors, "ERROR");
                this.generateEventOutcome(this.warns, "WARN");
                this.generateEventOutcome(this.hints, "HINT");
                this.endElement("rdf:Seq");
                this.endElement("premis:hasEventOutcomeInformation");
            }
            this.startElement("premis:hasEventRelatedAgent", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement("premis:hasAgentType", null, KeyValue.with("rdf:resource", "http://id.loc.gov/vocabulary/preservation/agentType/sof"));
            if (this.epubCheckVersion == null) {
                this.generateElement("premis:hasAgentName", this.epubCheckName);
            } else {
                this.generateElement("premis:hasAgentName", this.epubCheckName + " " + this.epubCheckVersion);
            }
            this.endElement("premis:hasEventRelatedAgent");
            this.endElement("premis:hasEvent");
            this.startElement("premis:hasSignificantProperties");
            this.startElement("rdf:Bag");
            this.generateSignificantProperty("renditionLayout", this.hasFixedLayout ? "fixed-layout" : "reflowable");
            this.generateSignificantProperty("isScripted", Boolean.toString(this.hasScripts));
            this.generateSignificantProperty("hasEncryption", Boolean.toString(this.hasEncryption));
            this.generateSignificantProperty("hasAudio", Boolean.toString(this.hasAudio));
            this.generateSignificantProperty("hasVideo", Boolean.toString(this.hasVideo));
            this.generateSignificantProperty("hasSignatures", Boolean.toString(this.hasSignatures));
            this.generateSignificantProperty("hasAllFontsEmbedded", Boolean.toString(this.refFonts.isEmpty()));
            int nRefs = 0;
            for (String ref : this.references) {
                if (++nRefs > 50) {
                    this.generateSignificantProperty("reference", "" + (this.references.size() - 50) + " more references");
                    break;
                }
                this.generateSignificantProperty("reference", ref);
            }
            this.endElement("rdf:Bag");
            this.endElement("premis:hasSignificantProperties");
            this.endElement("rdf:Description");
            this.endElement("rdf:RDF");
            this.endElement("x:xmpmeta");
            returnCode = 0;
        }
        catch (Exception e) {
            System.err.println("Exception encountered: " + e.getMessage());
            returnCode = 1;
        }
        return returnCode;
    }

    protected void generateFont(String font, boolean embeded) {
        String[] elFont = font.split(",");
        ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
        attrs.add(KeyValue.with("stFnt:fontFamily", this.capitalize(elFont[0])));
        String fontFace = "";
        for (int i = 1; i < elFont.length; ++i) {
            fontFace = fontFace + this.capitalize(elFont[i]) + " ";
        }
        if ((fontFace = fontFace.trim()).length() == 0) {
            attrs.add(KeyValue.with("stFnt:fontFace", "Regular"));
        } else {
            attrs.add(KeyValue.with("stFnt:fontFace", fontFace));
        }
        this.generateElement("rdf:li", null, attrs);
    }

    private void generateEventOutcome(List<CheckMessage> messages, String sev) {
        for (CheckMessage c : messages) {
            this.startElement("rdf:li", KeyValue.with("rdf:parseType", "Resource"));
            this.generateElement("premis:hasEventOutcome", c.getID() + ", " + sev + ", " + c.getMessage());
            if (c.getLocations().size() != 0) {
                this.startElement("premis:hasEventOutcomeDetail");
                this.startElement("rdf:Seq");
                String previousValue = "";
                for (EPUBLocation ml : c.getLocations()) {
                    String value = ml.getPath();
                    if (ml.getLine() > 0 || ml.getColumn() > 0) {
                        value = value + " (" + ml.getLine() + "-" + ml.getColumn() + ")";
                    }
                    if (previousValue.equals(value)) continue;
                    this.generateElement("rdf:li", null, KeyValue.with("premis:hasEventOutcomeDetailNote", value));
                    previousValue = value;
                }
                this.endElement("rdf:Seq");
                this.endElement("premis:hasEventOutcomeDetail");
            }
            this.endElement("rdf:li");
        }
    }

    private void generateSignificantProperty(String property, String value) {
        ArrayList<KeyValue<String, String>> attrs = new ArrayList<KeyValue<String, String>>();
        attrs.add(KeyValue.with("premis:hasSignificantPropertiesType", property));
        attrs.add(KeyValue.with("premis:hasSignificantPropertiesValue", value));
        this.generateElement("rdf:li", null, attrs);
    }
}

