/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.NumberListHandler;
import io.sf.carte.echosvg.parser.NumberParser;
import io.sf.carte.echosvg.parser.ParseException;
import java.io.IOException;
import org.w3c.css.om.unit.CSSUnit;

public class NumberListParser
extends NumberParser {
    private NumberListHandler numberListHandler;
    private boolean numberStarted = false;

    public NumberListParser(NumberListHandler numberListHandler) {
        this.numberListHandler = numberListHandler;
    }

    public void setNumberListHandler(NumberListHandler numberListHandler) {
        this.numberListHandler = numberListHandler;
    }

    public NumberListHandler getNumberListHandler() {
        return this.numberListHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        this.numberListHandler.startNumberList();
        this.current = this.reader.read();
        this.skipSpaces();
        try {
            do {
                this.numberListHandler.startNumber();
                this.numberStarted = true;
                float f = this.parseFloat();
                this.numberListHandler.numberValue(f);
                this.numberListHandler.endNumber();
                this.numberStarted = false;
                this.skipCommaSpaces();
            } while (this.current != -1);
        }
        catch (CalcParseException calcParseException) {
            this.cssParse();
        }
        catch (NumberFormatException numberFormatException) {
            this.reportUnexpectedCharacterError(this.current);
        }
        this.numberListHandler.endNumberList();
    }

    @Override
    protected void handleNumber(short s, float f) throws ParseException {
        if (s != 0) {
            throw new ParseException(this.createErrorMessage("dimension.not.number", new Object[]{CSSUnit.dimensionUnitString((short)s)}), -1, -1);
        }
        if (!this.numberStarted) {
            this.numberListHandler.startNumber();
        }
        this.numberListHandler.numberValue(f);
        this.numberListHandler.endNumber();
        this.numberStarted = false;
    }
}

