/*
 * Decompiled with CFR 0.152.
 */
package help;

import java.net.URI;
import java.nio.file.Path;

public class ImageLocation {
    private Path sourceFile;
    private String imageSrc;
    private Path resolvedPath;
    private URI resolvedUri;
    private boolean isRemote;
    private boolean isRuntime;
    private boolean invalidRuntimeImage;

    public static ImageLocation createLocalLocation(Path sourceFile, String imageSrc, URI resolvedUri, Path resolvedPath) {
        ImageLocation l = new ImageLocation(sourceFile, imageSrc);
        l.resolvedUri = resolvedUri;
        l.resolvedPath = resolvedPath;
        l.isRemote = false;
        l.isRuntime = false;
        return l;
    }

    public static ImageLocation createRuntimeLocation(Path sourceFile, String imageSrc, URI resolvedUri, Path resolvedPath) {
        ImageLocation l = new ImageLocation(sourceFile, imageSrc);
        l.resolvedUri = resolvedUri;
        l.resolvedPath = resolvedPath;
        l.isRemote = false;
        l.isRuntime = true;
        return l;
    }

    public static ImageLocation createInvalidRuntimeLocation(Path sourceFile, String imageSrc) {
        ImageLocation l = new ImageLocation(sourceFile, imageSrc);
        l.resolvedUri = null;
        l.resolvedPath = null;
        l.isRemote = false;
        l.isRuntime = true;
        l.invalidRuntimeImage = true;
        return l;
    }

    public static ImageLocation createRemoteLocation(Path sourceFile, String imageSrc, URI resolvedUri) {
        ImageLocation l = new ImageLocation(sourceFile, imageSrc);
        l.resolvedUri = resolvedUri;
        l.resolvedPath = null;
        l.isRemote = true;
        l.isRuntime = false;
        return l;
    }

    private ImageLocation(Path sourceFile, String imageSrc) {
        this.sourceFile = sourceFile;
        this.imageSrc = imageSrc;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public String getImageSrc() {
        return this.imageSrc;
    }

    public Path getResolvedPath() {
        return this.resolvedPath;
    }

    public URI getResolvedUri() {
        return this.resolvedUri;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public boolean isInvalidRuntimeImage() {
        return this.invalidRuntimeImage;
    }

    public String toString() {
        return "{\n\tsource file: " + String.valueOf(this.sourceFile) + ",\n\tsrc: " + this.imageSrc + ",\n\turi: " + String.valueOf(this.resolvedUri) + ",\n\tpath: " + String.valueOf(this.resolvedPath) + ",\n\tis runtime: " + this.isRuntime + ",\n\tis remote: " + this.isRemote + "\n}";
    }
}

