/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.services.DebuggerAutoMappingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceProvided;
import ghidra.framework.plugintool.util.PluginStatus;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

@PluginInfo(shortDescription="Debugger module and section manager", description="GUI to manage modules and sections", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerStaticMappingService.class, DebuggerTraceManagerService.class, ProgramManager.class}, servicesProvided={DebuggerAutoMappingService.class})
public class DebuggerModulesPlugin
extends AbstractDebuggerPlugin {
    @AutoServiceProvided(iface=DebuggerAutoMappingService.class)
    protected DebuggerModulesProvider provider;

    public DebuggerModulesPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerModulesProvider(this);
        super.init();
    }

    protected void dispose() {
        this.provider.dispose();
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        PluginEvent pluginEvent = event;
        Objects.requireNonNull(pluginEvent);
        PluginEvent pluginEvent2 = pluginEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgramOpenedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, (Object)pluginEvent2, n)) {
            case 0: {
                ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)pluginEvent2;
                this.provider.programOpened(ev.getProgram());
                break;
            }
            case 1: {
                ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)pluginEvent2;
                this.provider.setProgram(ev.getActiveProgram());
                break;
            }
            case 2: {
                ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)pluginEvent2;
                this.provider.setLocation(ev.getLocation());
                break;
            }
            case 3: {
                ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)pluginEvent2;
                this.provider.programClosed(ev.getProgram());
                break;
            }
            case 4: {
                TraceOpenedPluginEvent ev = (TraceOpenedPluginEvent)pluginEvent2;
                this.provider.traceOpened(ev.getTrace());
                break;
            }
            case 5: {
                TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)pluginEvent2;
                this.provider.coordinatesActivated(ev.getActiveCoordinates());
                break;
            }
            case 6: {
                TraceClosedPluginEvent ev = (TraceClosedPluginEvent)pluginEvent2;
                this.provider.traceClosed(ev.getTrace());
                break;
            }
        }
    }

    public void readConfigState(SaveState saveState) {
        this.provider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.provider.writeConfigState(saveState);
    }
}

