/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableTargetBreakpointActionItem;
import ghidra.async.AsyncFence;
import ghidra.debug.api.target.Target;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;

public class BreakpointActionSet
extends LinkedHashSet<BreakpointActionItem> {
    public EnableTargetBreakpointActionItem planEnableTarget(Target target, TraceBreakpoint bpt) {
        EnableTargetBreakpointActionItem action = new EnableTargetBreakpointActionItem(target, bpt);
        this.add(action);
        return action;
    }

    public EnableEmuBreakpointActionItem planEnableEmu(TraceBreakpoint bpt, long snap) {
        EnableEmuBreakpointActionItem action = new EnableEmuBreakpointActionItem(bpt, snap);
        this.add(action);
        return action;
    }

    public DisableTargetBreakpointActionItem planDisableTarget(Target target, TraceBreakpoint bpt) {
        DisableTargetBreakpointActionItem action = new DisableTargetBreakpointActionItem(target, bpt);
        this.add(action);
        return action;
    }

    public DisableEmuBreakpointActionItem planDisableEmu(TraceBreakpoint bpt, long snap) {
        DisableEmuBreakpointActionItem action = new DisableEmuBreakpointActionItem(bpt, snap);
        this.add(action);
        return action;
    }

    public DeleteTargetBreakpointActionItem planDeleteTarget(Target target, TraceBreakpoint bpt) {
        DeleteTargetBreakpointActionItem action = new DeleteTargetBreakpointActionItem(target, bpt);
        this.add(action);
        return action;
    }

    public DeleteEmuBreakpointActionItem planDeleteEmu(TraceBreakpoint bpt, long snap) {
        DeleteEmuBreakpointActionItem action = new DeleteEmuBreakpointActionItem(bpt, snap);
        this.add(action);
        return action;
    }

    public CompletableFuture<Void> execute() {
        AsyncFence fence = new AsyncFence();
        for (BreakpointActionItem item : this) {
            fence.include(item.execute());
        }
        return fence.ready();
    }
}

