/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BlockModelGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    private CodeBlockModel blockModel;

    public BlockModelGraphDisplayListener(PluginTool tool, CodeBlockModel blockModel, GraphDisplay display) {
        super(tool, blockModel.getProgram(), display);
        this.blockModel = blockModel;
    }

    public Address getAddress(AttributedVertex vertex) {
        return super.getAddress(vertex);
    }

    protected String getVertexId(Address address) {
        try {
            CodeBlock[] blocks = this.blockModel.getCodeBlocksContaining(address, TaskMonitor.DUMMY);
            if (blocks != null && blocks.length > 0) {
                return super.getVertexId(blocks[0].getFirstStartAddress());
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return super.getVertexId(address);
    }

    protected Set<AttributedVertex> getVertices(AddressSetView addrSet) {
        if (addrSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        try {
            this.addVerticesForAddresses(addrSet, vertices);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return vertices;
    }

    private void addVerticesForAddresses(AddressSetView addrSet, Set<AttributedVertex> vertices) throws CancelledException {
        SymbolTable symTable = this.program.getSymbolTable();
        CodeBlockIterator it = this.blockModel.getCodeBlocksContaining(addrSet, TaskMonitor.DUMMY);
        while (it.hasNext()) {
            AttributedVertex vertex;
            String addrString;
            CodeBlock block = it.next();
            Address addr = block.getFirstStartAddress();
            if (addr.isExternalAddress()) {
                Symbol s = symTable.getPrimarySymbol(addr);
                addrString = s.getName(true);
            } else {
                addrString = addr.toString();
            }
            if ((vertex = this.graphDisplay.getGraph().getVertex(addrString)) == null) continue;
            vertices.add(vertex);
        }
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertices) {
        AddressSet addrSet = new AddressSet();
        try {
            for (AttributedVertex vertex : vertices) {
                this.addBlockAddresses(addrSet, vertex);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return addrSet;
    }

    private void addBlockAddresses(AddressSet addrSet, AttributedVertex vertex) throws CancelledException {
        Address blockAddr = this.getAddress(vertex);
        if (!this.isValidAddress(blockAddr)) {
            return;
        }
        CodeBlock[] blocks = null;
        if (this.blockModel != null) {
            CodeBlock block = this.blockModel.getCodeBlockAt(blockAddr, TaskMonitor.DUMMY);
            blocks = block != null ? new CodeBlock[]{block} : this.blockModel.getCodeBlocksContaining(blockAddr, TaskMonitor.DUMMY);
        }
        if (blocks != null && blocks.length > 0) {
            for (CodeBlock block : blocks) {
                addrSet.add((AddressSetView)block);
            }
        } else {
            addrSet.addRange(blockAddr, blockAddr);
        }
    }

    protected boolean isValidAddress(Address addr) {
        if (addr == null || this.program == null) {
            return false;
        }
        return this.program.getMemory().contains(addr) || addr.isExternalAddress();
    }

    public GraphDisplayListener cloneWith(GraphDisplay newGraphDisplay) {
        return new BlockModelGraphDisplayListener(this.tool, this.blockModel, newGraphDisplay);
    }
}

